/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mazz.i18n.Logger;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.DumpBytes;

public class PersistentFifo {
    private static final Logger LOG = CommI18NFactory.getLogger(PersistentFifo.class);
    private static final Object m_fileLock = PersistentFifo.class;
    private File m_file;
    private RandomAccessFile m_randomAccessFile;
    private long m_count;
    private long m_head;
    private long m_tail;
    private long m_countPosition;
    private long m_headPosition;
    private long m_tailPosition;
    private long m_longSize;
    private long m_maxSizeBytes;
    private long m_purgeResultMaxBytes;
    private boolean m_compress;

    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        boolean objects = false;
        boolean compressed = false;
        int raw_bytes_base = -1;
        if (args.length > 1) {
            objects = "objects".equals(args[1]);
            compressed = args.length == 3 && "compressed".equals(args[2]);
            raw_bytes_base = objects ? 0 : 16;
        }
        PersistentFifo.dumpContents(new PrintWriter(System.out), file, compressed, raw_bytes_base);
    }

    public static void dumpContents(PrintWriter out, File fifo_file, boolean compressed, int raw_byte_base) throws IOException {
        PersistentFifo fifo = new PersistentFifo(fifo_file, Long.MAX_VALUE, 99, compressed);
        out.println(fifo_file);
        out.println(fifo.count());
        out.flush();
        if (raw_byte_base < 0) {
            return;
        }
        RandomAccessFile raf = fifo.getRandomAccessFile();
        boolean last_entry = fifo.m_head == -1L;
        long entry_num = 0L;
        if (!last_entry) {
            raf.seek(fifo.m_head);
        }
        while (!last_entry) {
            String entry_string;
            long next = raf.readLong();
            if (next == -1L) {
                next = raf.length() - raf.getFilePointer();
                last_entry = true;
            }
            int entry_size = (int)next;
            byte[] entry = new byte[entry_size];
            raf.readFully(entry);
            if (fifo.m_compress) {
                entry = fifo.decompress(entry);
            }
            out.print("[" + entry_num++ + "] ");
            if (raw_byte_base == 0) {
                Object obj = StreamUtil.deserialize((byte[])entry);
                entry_string = obj.toString();
            } else {
                out.println();
                switch (raw_byte_base) {
                    case 16: {
                        entry_string = DumpBytes.dumpHexData(entry);
                        break;
                    }
                    case 10: {
                        entry_string = DumpBytes.dumpDecData(entry);
                        break;
                    }
                    case 8: {
                        entry_string = DumpBytes.dumpOctData(entry);
                        break;
                    }
                    case 2: {
                        entry_string = DumpBytes.dumpBinData(entry);
                        break;
                    }
                    default: {
                        entry_string = DumpBytes.dumpData(entry, 7, raw_byte_base);
                    }
                }
            }
            out.println(entry_string);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentFifo(File file, long max_size_bytes, int purge_percentage, boolean compress) throws IOException {
        if (purge_percentage < 0 || purge_percentage > 99) {
            throw new IllegalArgumentException(LOG.getMsgString("PersistentFifo.invalid-purge-percentage", new Object[]{purge_percentage}));
        }
        if (max_size_bytes < 1000L) {
            throw new IllegalArgumentException(LOG.getMsgString("PersistentFifo.invalid-max-size", new Object[]{max_size_bytes, 1000}));
        }
        this.m_file = file;
        this.m_purgeResultMaxBytes = (int)((float)max_size_bytes * ((float)purge_percentage / 100.0f));
        this.m_maxSizeBytes = max_size_bytes;
        this.m_compress = compress;
        Object object = m_fileLock;
        synchronized (object) {
            if (!this.m_file.exists() || this.m_file.length() < 8L) {
                this.initializeEmptyFile();
            } else {
                RandomAccessFile raf = this.getRandomAccessFile();
                this.m_countPosition = 0L;
                this.readCount(raf);
                this.m_headPosition = raf.getFilePointer();
                this.readHead(raf);
                this.m_tailPosition = raf.getFilePointer();
                this.readTail(raf);
            }
            this.m_longSize = this.m_tailPosition - this.m_headPosition;
        }
    }

    public void putObject(Serializable o) throws IOException, RuntimeException {
        byte[] serialized_bytes = StreamUtil.serialize((Serializable)o);
        this.put(serialized_bytes);
    }

    public Object takeObject() throws IOException, RuntimeException {
        Object o = null;
        byte[] serialized_bytes = this.take();
        if (serialized_bytes != null) {
            o = StreamUtil.deserialize((byte[])serialized_bytes);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] bytes) throws IOException {
        if (this.m_compress) {
            bytes = this.compress(bytes);
        }
        Object object = m_fileLock;
        synchronized (object) {
            RandomAccessFile raf = this.getRandomAccessFile();
            long new_entry_pos = raf.length();
            boolean is_first_entry = this.m_head == -1L;
            this.writeCount(raf, ++this.m_count);
            if (is_first_entry) {
                this.writeHead(raf, new_entry_pos);
            } else {
                raf.seek(this.m_tail);
                raf.writeLong(new_entry_pos - this.m_tail - this.m_longSize);
            }
            raf.seek(new_entry_pos);
            raf.writeLong(-1L);
            raf.write(bytes);
            this.writeTail(raf, new_entry_pos);
            if (raf.length() > this.m_maxSizeBytes) {
                this.purge(raf, raf.length() - this.m_purgeResultMaxBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] take() throws IOException {
        Object object = m_fileLock;
        synchronized (object) {
            if (this.m_head == -1L) {
                return null;
            }
            RandomAccessFile raf = this.getRandomAccessFile();
            boolean last_entry = false;
            raf.seek(this.m_head);
            long next = raf.readLong();
            if (next == -1L) {
                next = raf.length() - raf.getFilePointer();
                last_entry = true;
            }
            int entry_size = (int)next;
            byte[] entry = new byte[entry_size];
            raf.readFully(entry);
            if (last_entry) {
                this.initializeEmptyFile();
            } else {
                this.writeHead(raf, this.m_head + next + this.m_longSize);
                this.writeCount(raf, --this.m_count);
            }
            if (this.m_compress) {
                entry = this.decompress(entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() throws IOException {
        Object object = m_fileLock;
        synchronized (object) {
            return this.readHead(this.getRandomAccessFile()) == -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() throws IOException {
        Object object = m_fileLock;
        synchronized (object) {
            return this.readCount(this.getRandomAccessFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeEmptyFile() throws IOException {
        Object object = m_fileLock;
        synchronized (object) {
            this.m_count = 0L;
            this.m_head = -1L;
            this.m_tail = -1L;
            RandomAccessFile raf = this.getRandomAccessFile();
            this.m_countPosition = 0L;
            raf.seek(this.m_countPosition);
            raf.writeLong(this.m_count);
            this.m_headPosition = raf.getFilePointer();
            raf.seek(this.m_headPosition);
            raf.writeLong(this.m_head);
            this.m_tailPosition = raf.getFilePointer();
            raf.writeLong(this.m_tail);
            raf.setLength(raf.getFilePointer());
        }
    }

    private void purge(RandomAccessFile raf, long bytes_to_purge) throws IOException {
        long first_data_byte = this.m_tailPosition + this.m_longSize;
        long unused_bytes = this.m_head - first_data_byte;
        while (unused_bytes < bytes_to_purge) {
            this.take();
            if (this.m_head == -1L) {
                return;
            }
            unused_bytes = this.m_head - first_data_byte;
        }
        byte[] chunk = new byte[(int)unused_bytes];
        long total_bytes_to_move = raf.length() - first_data_byte - unused_bytes;
        long num_full_chunks = total_bytes_to_move / unused_bytes;
        long final_chunk_size = total_bytes_to_move % unused_bytes;
        long cur_pos_to_read = this.m_head;
        long cur_pos_to_write = first_data_byte;
        int i = 0;
        while ((long)i < num_full_chunks) {
            raf.seek(cur_pos_to_read);
            raf.readFully(chunk);
            raf.seek(cur_pos_to_write);
            raf.write(chunk);
            cur_pos_to_read += (long)chunk.length;
            cur_pos_to_write += (long)chunk.length;
            ++i;
        }
        if (final_chunk_size > 0L) {
            raf.seek(cur_pos_to_read);
            raf.readFully(chunk, 0, (int)final_chunk_size);
            raf.seek(cur_pos_to_write);
            raf.write(chunk, 0, (int)final_chunk_size);
        }
        raf.setLength(raf.getFilePointer());
        this.writeHead(raf, first_data_byte);
        this.writeTail(raf, this.m_tail - unused_bytes);
    }

    private RandomAccessFile getRandomAccessFile() throws FileNotFoundException {
        if (this.m_randomAccessFile == null) {
            this.m_randomAccessFile = new RandomAccessFile(this.m_file, "rw");
        }
        return this.m_randomAccessFile;
    }

    private long readCount(RandomAccessFile raf) throws IOException {
        raf.seek(this.m_countPosition);
        this.m_count = raf.readLong();
        return this.m_count;
    }

    private void writeCount(RandomAccessFile raf, long count) throws IOException {
        raf.seek(this.m_countPosition);
        raf.writeLong(count);
        this.m_count = count;
    }

    private long readHead(RandomAccessFile raf) throws IOException {
        raf.seek(this.m_headPosition);
        this.m_head = raf.readLong();
        return this.m_head;
    }

    private void writeHead(RandomAccessFile raf, long head_pos) throws IOException {
        raf.seek(this.m_headPosition);
        raf.writeLong(head_pos);
        this.m_head = head_pos;
    }

    private long readTail(RandomAccessFile raf) throws IOException {
        raf.seek(this.m_tailPosition);
        this.m_tail = raf.readLong();
        return this.m_tail;
    }

    private void writeTail(RandomAccessFile raf, long tail_pos) throws IOException {
        raf.seek(this.m_tailPosition);
        raf.writeLong(tail_pos);
        this.m_tail = tail_pos;
    }

    private byte[] compress(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        GZIPOutputStream gzip = new GZIPOutputStream(baos);
        gzip.write(bytes);
        gzip.close();
        bytes = baos.toByteArray();
        baos = null;
        return bytes;
    }

    private byte[] decompress(byte[] entry) throws IOException {
        ByteArrayOutputStream decompressed = new ByteArrayOutputStream(entry.length);
        ByteArrayInputStream in = new ByteArrayInputStream(entry);
        GZIPInputStream gzip_in = new GZIPInputStream(in);
        StreamUtil.copy((InputStream)gzip_in, (OutputStream)decompressed);
        entry = decompressed.toByteArray();
        return entry;
    }
}

