/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.rhq.enterprise.communications.command.CommandType;
import org.rhq.enterprise.communications.command.server.CommandMBean;
import org.rhq.enterprise.communications.command.server.CommandServiceDirectoryEntry;
import org.rhq.enterprise.communications.command.server.CommandServiceDirectoryMBean;
import org.rhq.enterprise.communications.command.server.CommandServiceMBean;

public class CommandServiceDirectory
extends CommandMBean
implements CommandServiceDirectoryMBean,
NotificationListener {
    static final String NULL_SUBSYSTEM = ",null,";
    private Map<String, Map<CommandType, ObjectName>> m_allCommandTypes = new HashMap<String, Map<CommandType, ObjectName>>();
    private boolean m_allowDynamicDiscovery = false;

    @Override
    public ObjectName preRegister(MBeanServer mbs, ObjectName name) throws Exception {
        if (!"directory".equals(name.getKeyProperty("type"))) {
            String errorMsg = this.getLog().getMsgString("CommandServiceDirectory.invalid-self-name", new Object[]{name, "type", "directory"});
            throw new IllegalArgumentException(errorMsg);
        }
        return super.preRegister(mbs, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService() {
        try {
            Map<String, Map<CommandType, ObjectName>> map = this.m_allCommandTypes;
            synchronized (map) {
                this.m_allCommandTypes.clear();
                boolean discoveryFlagBackup = this.m_allowDynamicDiscovery;
                this.startListening();
                this.m_allowDynamicDiscovery = true;
                this.inventory();
                this.m_allowDynamicDiscovery = discoveryFlagBackup;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(this.getLog().getMsgString("CommandServiceDirectory.failed-to-start", new Object[0]), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService() {
        Map<String, Map<CommandType, ObjectName>> map = this.m_allCommandTypes;
        synchronized (map) {
            this.stopListening();
            this.m_allCommandTypes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        MBeanServerNotification mbsNotif = null;
        if (notification instanceof MBeanServerNotification) {
            mbsNotif = (MBeanServerNotification)notification;
            Map<String, Map<CommandType, ObjectName>> map = this.m_allCommandTypes;
            synchronized (map) {
                if ("JMX.mbean.registered".equals(mbsNotif.getType())) {
                    this.addAllSupportedCommandTypes(mbsNotif.getMBeanName());
                } else if ("JMX.mbean.unregistered".equals(mbsNotif.getType())) {
                    this.removeAllSupportedCommandTypes(mbsNotif.getMBeanName());
                } else {
                    mbsNotif = null;
                }
            }
        }
        if (mbsNotif == null) {
            this.getLog().warn(this.getLog().getMsgString("CommandServiceDirectory.unknown-notif", new Object[]{notification}), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandServiceDirectoryEntry getCommandTypeProvider(String subsystem, CommandType commandType) {
        CommandServiceDirectoryEntry retEntry = null;
        ObjectName commandServiceName = null;
        Map<String, Map<CommandType, ObjectName>> map = this.m_allCommandTypes;
        synchronized (map) {
            Map<CommandType, ObjectName> subsystemServices = this.getSubsystemCommandTypes(subsystem);
            commandServiceName = subsystemServices.get(commandType);
        }
        if (commandServiceName != null) {
            retEntry = new CommandServiceDirectoryEntry(subsystem, commandType, commandServiceName);
        }
        return retEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandServiceDirectoryEntry[] getSubsystemEntries(String subsystem) {
        ArrayList<CommandServiceDirectoryEntry> entries = new ArrayList<CommandServiceDirectoryEntry>();
        Map<String, Map<CommandType, ObjectName>> map = this.m_allCommandTypes;
        synchronized (map) {
            Map<CommandType, ObjectName> subsystemServices = this.getSubsystemCommandTypes(subsystem);
            for (Map.Entry<CommandType, ObjectName> mapEntry : subsystemServices.entrySet()) {
                entries.add(new CommandServiceDirectoryEntry(subsystem, mapEntry.getKey(), mapEntry.getValue()));
            }
        }
        return entries.toArray(new CommandServiceDirectoryEntry[entries.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandServiceDirectoryEntry[] getAllEntries() {
        ArrayList<CommandServiceDirectoryEntry> entries = new ArrayList<CommandServiceDirectoryEntry>();
        Map<String, Map<CommandType, ObjectName>> map = this.m_allCommandTypes;
        synchronized (map) {
            for (String subsystem : this.m_allCommandTypes.keySet()) {
                CommandServiceDirectoryEntry[] subsystemEntries = this.getSubsystemEntries(subsystem);
                for (int i = 0; i < subsystemEntries.length; ++i) {
                    entries.add(subsystemEntries[i]);
                }
            }
        }
        return entries.toArray(new CommandServiceDirectoryEntry[entries.size()]);
    }

    @Override
    public void setAllowDynamicDiscovery(boolean flag) {
        if (flag) {
            this.getLog().debug("CommandServiceDirectory.dynamic-discovery-allowed", new Object[0]);
        }
        this.m_allowDynamicDiscovery = flag;
    }

    @Override
    public boolean getAllowDynamicDiscovery() {
        return this.m_allowDynamicDiscovery;
    }

    private void startListening() throws Exception {
        ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        this.getMBeanServer().addNotificationListener(delegate, this, null, null);
    }

    private void stopListening() {
        try {
            ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.getMBeanServer().removeNotificationListener(delegate, this);
        }
        catch (Exception e) {
            this.getLog().warn((Throwable)e, "CommandServiceDirectory.listener-removal-failure", new Object[0]);
        }
    }

    private void inventory() throws Exception {
        String type = "type=command";
        ObjectName query = new ObjectName("*:*," + type);
        Set<ObjectName> commandServices = this.getMBeanServer().queryNames(query, null);
        for (ObjectName newCommandServiceName : commandServices) {
            MBeanServerNotification notif = new MBeanServerNotification("JMX.mbean.registered", (Object)this, 0L, newCommandServiceName);
            this.handleNotification(notif, null);
        }
    }

    private String getSubsystem(ObjectName commandServiceName) {
        String retSubsystem = commandServiceName.getKeyProperty("subsystem");
        if (retSubsystem == null) {
            retSubsystem = NULL_SUBSYSTEM;
        }
        return retSubsystem;
    }

    private boolean isCommandService(ObjectName name) {
        return "command".equals(name.getKeyProperty("type"));
    }

    private CommandType[] getCommandServiceCommands(ObjectName name) {
        CommandType[] retComandTypes = null;
        try {
            CommandServiceMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServer(), name, CommandServiceMBean.class, false);
            retComandTypes = proxy.getSupportedCommandTypes();
        }
        catch (Exception e) {
            this.getLog().trace("Misc.exception", new Object[]{e});
        }
        return retComandTypes;
    }

    private Map<CommandType, ObjectName> getSubsystemCommandTypes(String subsystem) {
        Map<CommandType, ObjectName> retSubsystemMap;
        if (subsystem == null) {
            subsystem = NULL_SUBSYSTEM;
        }
        if ((retSubsystemMap = this.m_allCommandTypes.get(subsystem)) == null) {
            retSubsystemMap = new HashMap<CommandType, ObjectName>();
            this.m_allCommandTypes.put(subsystem, retSubsystemMap);
        }
        return retSubsystemMap;
    }

    private void removeSubsystemCommandTypesIfEmpty(String subsystem) {
        Map<CommandType, ObjectName> subsystemMap;
        if (subsystem == null) {
            subsystem = NULL_SUBSYSTEM;
        }
        if ((subsystemMap = this.m_allCommandTypes.get(subsystem)).size() == 0) {
            this.m_allCommandTypes.remove(subsystem);
        }
    }

    private void addSupportedCommandType(CommandType commandType, ObjectName commandServiceName) {
        String subsystem = this.getSubsystem(commandServiceName);
        Map<CommandType, ObjectName> subsystemMap = this.getSubsystemCommandTypes(subsystem);
        subsystemMap.put(commandType, commandServiceName);
        this.getLog().debug("CommandServiceDirectory.new-supported-command", new Object[]{commandType, commandServiceName});
    }

    private void removeSupportedCommandType(CommandType commandType, ObjectName commandServiceName) {
        String subsystem = this.getSubsystem(commandServiceName);
        Map<CommandType, ObjectName> subsystemMap = this.getSubsystemCommandTypes(subsystem);
        ObjectName mappedCommandService = subsystemMap.get(commandType);
        if (commandServiceName.equals(mappedCommandService)) {
            subsystemMap.remove(commandType);
            this.getLog().debug("CommandServiceDirectory.removed-command-support", new Object[]{commandType, commandServiceName});
            this.removeSubsystemCommandTypesIfEmpty(subsystem);
        } else {
            this.getLog().warn("CommandServiceDirectory.removal-failure", new Object[]{commandType, commandServiceName, mappedCommandService});
        }
    }

    private void addAllSupportedCommandTypes(ObjectName name) {
        if (this.isCommandService(name)) {
            if (this.m_allowDynamicDiscovery) {
                CommandType[] supportedCommandTypes = this.getCommandServiceCommands(name);
                if (supportedCommandTypes != null) {
                    for (int i = 0; i < supportedCommandTypes.length; ++i) {
                        this.addSupportedCommandType(supportedCommandTypes[i], name);
                    }
                }
            } else {
                this.getLog().warn("CommandServiceDirectory.detected-but-not-added", new Object[]{name});
            }
        }
    }

    private void removeAllSupportedCommandTypes(ObjectName name) {
        if (this.isCommandService(name)) {
            String subsystem = this.getSubsystem(name);
            Map<CommandType, ObjectName> subsystemMap = this.getSubsystemCommandTypes(subsystem);
            ArrayList<CommandType> doomedCommandTypes = new ArrayList<CommandType>();
            Set<Map.Entry<CommandType, ObjectName>> subsystemMapEntrySet = subsystemMap.entrySet();
            for (Map.Entry<CommandType, ObjectName> subsystemMapEntry : subsystemMapEntrySet) {
                if (!name.equals(subsystemMapEntry.getValue())) continue;
                doomedCommandTypes.add(subsystemMapEntry.getKey());
            }
            for (CommandType doomedCommandType : doomedCommandTypes) {
                this.removeSupportedCommandType(doomedCommandType, name);
            }
        }
    }
}

