/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import java.sql.SQLException;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;

public class SST_Insert
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String table = null;
    private String insertCmd = null;
    private boolean dupFail = true;

    public void setTable(String t) {
        this.table = t;
    }

    public void setInsertCmd(String i) {
        this.insertCmd = i;
    }

    public void setDupFail(String df) {
        this.dupFail = Boolean.getBoolean(df);
    }

    public void execute() throws BuildException {
        if (!this.isDBTargeted()) {
            return;
        }
        this.validateAttributes();
        Connection conn = this.getConnection();
        DatabaseType db_type = this.getDatabaseType();
        try {
            this.log(MSG.getMsg("SchemaSpecTask.insert.executing", new Object[]{this.table, this.insertCmd}));
            db_type.insert(conn, this.table, this.insertCmd);
        }
        catch (SQLException e) {
            if (this.dupFail || e.getMessage().toLowerCase().indexOf("constraint") == -1) {
                throw new BuildException(MSG.getMsg("SchemaSpecTask.failure", new Object[]{"Insert", e}), (Throwable)e);
            }
            try {
                this.log(MSG.getMsg("SchemaSpecTask.insert.ignore-dup", new Object[]{this.table}));
                conn.rollback();
            }
            catch (SQLException ex) {
                throw new BuildException(MSG.getMsg("SchemaSpecTask.insert.rollback-error", new Object[]{ex}), (Throwable)ex);
            }
        }
        catch (Exception e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.failure", new Object[]{"Insert", e}), (Throwable)e);
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.table == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"Insert", "table"}));
        }
        if (this.insertCmd == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"Insert", "insertCmd"}));
        }
    }
}

