/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.JBossASClient;

public class MessagingJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_MESSAGING = "messaging";
    public static final String HORNETQ_SERVER = "hornetq-server";
    public static final String JMS_QUEUE = "jms-queue";

    public MessagingJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isQueue(String queueName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_MESSAGING, HORNETQ_SERVER, "default");
        return null != this.findNodeInList(addr, haystack = JMS_QUEUE, queueName);
    }

    public ModelNode createNewQueueRequest(String name, Boolean durable, List<String> entryNames) {
        String dmrTemplate = "{\"durable\" => \"%s\", \"entries\" => [\"%s\"] }";
        String dmr = String.format(dmrTemplate, null == durable ? "true" : durable.toString(), entryNames.get(0));
        Address addr = Address.root().add("subsystem", SUBSYSTEM_MESSAGING, HORNETQ_SERVER, "default", JMS_QUEUE, name);
        ModelNode request = ModelNode.fromString((String)dmr);
        request.get("operation").set("add");
        request.get("address").set(addr.getAddressNode());
        return request;
    }
}

