/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.stream;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamUtil {
    private static final Log LOG = LogFactory.getLog(StreamUtil.class);

    private StreamUtil() {
    }

    private static String forHTMLTag(String aTagFragment) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(aTagFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            switch (character) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '\'': {
                    result.append("&#039;");
                    break;
                }
                case '\\': {
                    result.append("&#092;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '|': {
                    result.append("&#124;");
                    break;
                }
                case ',': {
                    result.append("&#44;");
                    break;
                }
                default: {
                    result.append(character);
                }
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static byte[] slurp(InputStream stream) throws RuntimeException {
        if (stream == null) {
            throw new IllegalArgumentException("Input stream is null.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtil.copy(stream, out, true);
        return out.toByteArray();
    }

    public static String slurp(Reader reader) throws RuntimeException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader is null.");
        }
        StringWriter wrt = new StringWriter();
        StreamUtil.copy(reader, wrt);
        return wrt.toString();
    }

    public static long copy(InputStream input, OutputStream output) throws RuntimeException {
        return StreamUtil.copy(input, output, true);
    }

    public static long copy(Reader rdr, Writer wrt) throws RuntimeException {
        return StreamUtil.copy(rdr, wrt, true);
    }

    public static long copy(InputStream input, OutputStream output, boolean closeStreams) throws RuntimeException {
        return StreamUtil.copy(input, output, closeStreams, false);
    }

    public static long copy(InputStream input, OutputStream output, boolean closeStreams, boolean htmlEscape) throws RuntimeException {
        if (input == null) {
            throw new IllegalArgumentException("Input stream is null.");
        }
        if (output == null) {
            throw new IllegalArgumentException("Output stream is null.");
        }
        long numBytesCopied = 0L;
        int bufferSize = 32768;
        try {
            input = new BufferedInputStream(input, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = input.read(buffer);
            while (bytesRead != -1) {
                if (htmlEscape) {
                    String htmlEncodedStr = StreamUtil.forHTMLTag(new String(buffer, 0, bytesRead));
                    bytesRead = htmlEncodedStr.length();
                    output.write(htmlEncodedStr.getBytes(), 0, bytesRead);
                } else {
                    output.write(buffer, 0, bytesRead);
                }
                numBytesCopied += (long)bytesRead;
                bytesRead = input.read(buffer);
            }
            output.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Stream data cannot be copied", ioe);
        }
        finally {
            if (closeStreams) {
                try {
                    output.close();
                }
                catch (IOException ioe2) {
                    LOG.warn((Object)"Streams could not be closed", (Throwable)ioe2);
                }
                try {
                    input.close();
                }
                catch (IOException ioe2) {
                    LOG.warn((Object)"Streams could not be closed", (Throwable)ioe2);
                }
            }
        }
        return numBytesCopied;
    }

    public static long copy(Reader rdr, Writer wrt, boolean closeStreams) throws RuntimeException {
        if (rdr == null) {
            throw new IllegalArgumentException("Reader is null.");
        }
        if (wrt == null) {
            throw new IllegalArgumentException("Writer is null.");
        }
        try {
            int cnt;
            long numCharsCopied = 0L;
            char[] buffer = new char[32768];
            while ((cnt = rdr.read(buffer)) != -1) {
                numCharsCopied += (long)cnt;
                wrt.write(buffer, 0, cnt);
            }
            long l = numCharsCopied;
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException("Reader could not have been copied to the writer.", e);
        }
        finally {
            if (closeStreams) {
                try {
                    rdr.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Reader could not be closed.", (Throwable)ioe);
                }
                try {
                    wrt.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Writer could not be closed.", (Throwable)ioe);
                }
            }
        }
    }

    public static long copy(InputStream input, OutputStream output, long startByte, long length) throws RuntimeException {
        if (input == null) {
            throw new IllegalArgumentException("Input stream is null.");
        }
        if (output == null) {
            throw new IllegalArgumentException("Output stream is null.");
        }
        if (length == 0L) {
            return 0L;
        }
        if (startByte < 0L) {
            throw new IllegalArgumentException("startByte=" + startByte);
        }
        long numBytesCopied = 0L;
        int bufferSize = 32768;
        try {
            byte[] buffer = new byte[bufferSize];
            if (startByte > 0L) {
                input.skip(startByte);
            }
            int bytesRead = input.read(buffer, 0, length < 0L || length >= (long)bufferSize ? bufferSize : (int)length);
            while (bytesRead > 0) {
                output.write(buffer, 0, bytesRead);
                numBytesCopied += (long)bytesRead;
                bytesRead = input.read(buffer, 0, (length -= (long)bytesRead) < 0L || length >= (long)bufferSize ? bufferSize : (int)length);
            }
            output.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Stream data cannot be copied", ioe);
        }
        return numBytesCopied;
    }

    public static byte[] serialize(Serializable object) throws RuntimeException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(byteStream);
            oos.writeObject(object);
            oos.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to serialize object", ioe);
        }
        return byteStream.toByteArray();
    }

    public static Object deserialize(byte[] serializedData) throws RuntimeException {
        Object retObject;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(serializedData);
        try {
            ObjectInputStream ois = new ObjectInputStream(byteStream);
            retObject = ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize object", e);
        }
        return retObject;
    }

    public static void safeClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to close a stream.", (Throwable)e);
            }
        }
    }
}

