/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.installer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.rhq.enterprise.installer.PropertyItem;

public class PropertyItemWithValue {
    private PropertyItem itemDefinition;
    private String value;

    public PropertyItemWithValue(PropertyItem itemDefinition, String value) {
        this.setItemDefinition(itemDefinition);
        this.setValue(value);
    }

    public PropertyItem getItemDefinition() {
        return this.itemDefinition;
    }

    public void setItemDefinition(PropertyItem itemDefinition) {
        this.itemDefinition = itemDefinition;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value == null || value.trim().length() <= 0) {
            Class propertyType = this.itemDefinition.getPropertyType();
            if (Boolean.class.isAssignableFrom(propertyType)) {
                value = Boolean.FALSE.toString();
            } else if (Number.class.isAssignableFrom(propertyType)) {
                value = "0";
            } else if (InetAddress.class.isAssignableFrom(propertyType)) {
                try {
                    InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    value = "127.0.0.1";
                }
            } else {
                value = "";
            }
        }
        this.value = value;
    }

    public void setRawValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.itemDefinition.getPropertyName() + "=" + this.value;
    }
}

