/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.jmx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.jmx.ApplicationMBeansDiscoveryComponent;
import org.rhq.plugins.jmx.JMXComponent;

public class ApplicationMBeansComponent
implements JMXComponent<BaseComponent<?>> {
    private static final Log LOG = LogFactory.getLog(ApplicationMBeansComponent.class);
    private ResourceContext resourceContext;
    private Configuration pluginConfig;
    private EmsConnection emsConnection;
    private String beansQueryString;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.pluginConfig = resourceContext.getPluginConfiguration();
        this.beansQueryString = this.pluginConfig.getSimpleValue("beansQueryString");
        this.emsConnection = ApplicationMBeansDiscoveryComponent.loadEmsConnection(this.pluginConfig, resourceContext.getTemporaryDirectory());
    }

    public void stop() {
        this.pluginConfig = null;
        if (this.emsConnection != null) {
            this.emsConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmsConnection getEmsConnection() {
        ApplicationMBeansComponent applicationMBeansComponent = this;
        synchronized (applicationMBeansComponent) {
            if (this.emsConnection == null || !this.emsConnection.getConnectionProvider().isConnected()) {
                this.emsConnection = ApplicationMBeansDiscoveryComponent.loadEmsConnection(this.pluginConfig, this.resourceContext.getTemporaryDirectory());
            }
        }
        return this.emsConnection;
    }

    public AvailabilityType getAvailability() {
        EmsConnection connection = this.getEmsConnection();
        if (connection == null) {
            return AvailabilityType.DOWN;
        }
        if (!this.hasApplicationMBeans()) {
            LOG.warn((Object)("Found no MBeans with query '" + this.beansQueryString + "'"));
            return AvailabilityType.DOWN;
        }
        return AvailabilityType.UP;
    }

    protected boolean hasApplicationMBeans() {
        return !this.emsConnection.queryBeans(this.beansQueryString).isEmpty();
    }
}

