/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbossnetwork.product.jbpm.handlers;

import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerException;
import com.jboss.jbossnetwork.product.jbpm.handlers.BaseHandler;
import com.jboss.jbossnetwork.product.jbpm.handlers.ControlActionFacade;
import com.jboss.jbossnetwork.product.jbpm.handlers.HandlerUtils;
import org.jbpm.graph.exe.ExecutionContext;
import org.rhq.core.pluginapi.operation.OperationServicesResult;
import org.rhq.core.pluginapi.operation.OperationServicesResultCode;

public class ControlActionHandler
extends BaseHandler {
    private String actionName;

    @Override
    public void run(ExecutionContext executionContext) {
        ControlActions action;
        ControlActionFacade facade = (ControlActionFacade)executionContext.getVariable("controlActionFacade");
        try {
            action = Enum.valueOf(ControlActions.class, this.actionName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.error(executionContext, null, "Invalid action specified [" + this.actionName + "] to be executed on server.", "error");
            return;
        }
        OperationServicesResult result = null;
        Throwable operationError = null;
        try {
            switch (action) {
                case START: {
                    result = facade.start();
                    break;
                }
                case STOP: {
                    result = facade.stop();
                    break;
                }
                case STOPIFRUNNING: {
                    if (!facade.isRunning()) break;
                    result = facade.stop();
                    break;
                }
                case RESTART: {
                    result = facade.stop();
                    if (result.getResultCode() != OperationServicesResultCode.SUCCESS) break;
                    result = facade.start();
                }
            }
        }
        catch (Throwable e) {
            operationError = e;
        }
        OperationServicesResultCode code = result != null ? result.getResultCode() : (operationError == null ? OperationServicesResultCode.SUCCESS : OperationServicesResultCode.FAILURE);
        switch (code) {
            case SUCCESS: {
                this.complete(executionContext, "Successfully called [" + this.actionName + "] action on server.");
                break;
            }
            case FAILURE: {
                this.error(executionContext, operationError, "Failed calling [" + this.actionName + "] action on server.", "error");
                break;
            }
            case TIMED_OUT: {
                this.error(executionContext, operationError, "Action [" + this.actionName + "] timed out while executing on server.", "error");
            }
        }
    }

    @Override
    public String getDescription() {
        return "Carry out [" + this.actionName + "] action on the server.";
    }

    @Override
    protected void checkProperties() throws ActionHandlerException {
        HandlerUtils.checkIsSet("actionName", this.actionName);
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    private static enum ControlActions {
        START,
        STOP,
        STOPIFRUNNING,
        RESTART;

    }
}

