/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbossnetwork.product.jbpm.handlers;

import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerException;
import com.jboss.jbossnetwork.product.jbpm.handlers.BaseHandler;
import com.jboss.jbossnetwork.product.jbpm.handlers.HandlerUtils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.jbpm.graph.exe.ExecutionContext;
import org.rhq.core.util.stream.StreamUtil;

public class CompareDigestActionHandler
extends BaseHandler {
    private String algorithm;
    private String fileToBeCheckedLocation;
    private String expectedDigest;

    @Override
    public void run(ExecutionContext executionContext) {
        try {
            HandlerUtils.checkFilenameExists(this.fileToBeCheckedLocation);
            HandlerUtils.checkFilenameIsAFile(this.fileToBeCheckedLocation);
            HandlerUtils.checkFilenameIsReadable(this.fileToBeCheckedLocation);
            this.verifyDigest();
            this.complete(executionContext, "Successfully checked digest of [" + HandlerUtils.formatPath(this.fileToBeCheckedLocation) + "]. Confirmed to be [" + this.expectedDigest + "].");
        }
        catch (Throwable e) {
            this.error(executionContext, e, "No changes were made in this step.", "error");
        }
    }

    @Override
    public String getDescription() {
        return "Calculate the digest of [" + HandlerUtils.formatPath(this.getFileToBeCheckedLocation()) + "] using the [" + this.getAlgorithm() + "] algorithm and check it matches [" + this.getExpectedDigest() + "].";
    }

    @Override
    public void substituteVariables(ExecutionContext executionContext) throws ActionHandlerException {
        this.setFileToBeCheckedLocation(this.substituteVariable(this.fileToBeCheckedLocation, executionContext));
        this.setAlgorithm(this.substituteVariable(this.algorithm, executionContext));
        this.setExpectedDigest(this.substituteVariable(this.expectedDigest, executionContext));
    }

    @Override
    public void setPropertyDefaults() {
        if (this.algorithm == null) {
            this.setAlgorithm("MD5");
        }
        if (this.expectedDigest == null) {
            this.setExpectedDigest("#{software.MD5}");
        }
    }

    @Override
    protected void checkProperties() throws ActionHandlerException {
        HandlerUtils.checkIsSet("algorithm", this.algorithm);
        HandlerUtils.checkIsSet("fileToBeCheckedLocation", this.fileToBeCheckedLocation);
        HandlerUtils.checkIsSet("expectedDigest", this.expectedDigest);
    }

    private void verifyDigest() throws ActionHandlerException {
        String actualDigest;
        try {
            actualDigest = this.calculateDigest();
        }
        catch (Exception e) {
            throw new ActionHandlerException("Failed trying to calculate digest of [" + HandlerUtils.formatPath(this.fileToBeCheckedLocation) + "]", e);
        }
        if (!this.expectedDigest.equalsIgnoreCase(actualDigest)) {
            throw new ActionHandlerException("Digest of [" + HandlerUtils.formatPath(this.fileToBeCheckedLocation) + "] is [" + actualDigest + "] and does not match expected value [" + this.expectedDigest + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateDigest() throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
        DigestInputStream in = null;
        try {
            in = new DigestInputStream(new FileInputStream(this.fileToBeCheckedLocation), messageDigest);
            byte[] buffer = new byte[4096];
            while (in.read(buffer) != -1) {
            }
        }
        catch (Throwable throwable) {
            StreamUtil.safeClose(in);
            throw throwable;
        }
        StreamUtil.safeClose((Closeable)in);
        String digest = HandlerUtils.encode(messageDigest.digest());
        return digest;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getFileToBeCheckedLocation() {
        return this.fileToBeCheckedLocation;
    }

    public void setFileToBeCheckedLocation(String fileToBeCheckedLocation) {
        this.fileToBeCheckedLocation = fileToBeCheckedLocation;
    }

    public String getExpectedDigest() {
        return this.expectedDigest;
    }

    public void setExpectedDigest(String expectedDigest) {
        this.expectedDigest = expectedDigest;
    }
}

