/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.common.jbossas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.common.jbossas.JBPMWorkflowManager;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.util.exception.ThrowableUtil;

public abstract class AbstractJBossASContentFacetDelegate
implements ContentFacet {
    private final Log log = LogFactory.getLog(AbstractJBossASContentFacetDelegate.class);
    public static final String PACKAGE_TYPE_PATCH = "cumulativePatch";
    public static final String PACKAGE_TYPE_LIBRARY = "library";
    private JBPMWorkflowManager workflowManager;

    protected AbstractJBossASContentFacetDelegate(JBPMWorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        ContentResponseResult overallResult = ContentResponseResult.SUCCESS;
        ArrayList<DeployIndividualPackageResponse> individualResponses = new ArrayList<DeployIndividualPackageResponse>(packages.size());
        for (ResourcePackageDetails pkg : packages) {
            this.log.info((Object)("Attempting to deploy package: " + pkg));
            String packageTypeName = pkg.getPackageTypeName();
            if (packageTypeName.equals(PACKAGE_TYPE_PATCH)) {
                DeployIndividualPackageResponse response;
                if (packages.size() > 1) {
                    this.log.warn((Object)"Attempt to install more than one patch at a time, installation aborted.");
                    response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
                    response.setOverallRequestErrorMessage("When deploying a patch, no other packages may be deployed at the same time.");
                    return response;
                }
                try {
                    response = this.workflowManager.run(pkg);
                    if (response.getResult() == ContentResponseResult.FAILURE) {
                        overallResult = ContentResponseResult.FAILURE;
                    }
                    individualResponses.add(response);
                }
                catch (Throwable throwable) {
                    this.log.error((Object)("Error deploying package: " + pkg), throwable);
                    DeployIndividualPackageResponse response2 = new DeployIndividualPackageResponse(pkg.getKey(), ContentResponseResult.FAILURE);
                    response2.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)throwable));
                    individualResponses.add(response2);
                    overallResult = ContentResponseResult.FAILURE;
                }
                continue;
            }
            if (!packageTypeName.equals(PACKAGE_TYPE_LIBRARY)) continue;
            throw new UnsupportedOperationException("Deployment of new libraries is not supported by the plugin.");
        }
        DeployPackagesResponse response = new DeployPackagesResponse(overallResult);
        response.getPackageResponses().addAll(individualResponses);
        return response;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        throw new UnsupportedOperationException();
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        this.log.info((Object)("Translating installation steps for package: " + packageDetails));
        List<DeployPackageStep> steps = null;
        String packageTypeName = packageDetails.getPackageTypeName();
        if (packageTypeName.equals(PACKAGE_TYPE_PATCH)) {
            try {
                steps = this.workflowManager.translateSteps(packageDetails);
            }
            catch (Exception e) {
                this.log.error((Object)("Error translating installation steps for package: " + packageDetails), (Throwable)e);
            }
            this.log.info((Object)("Translated number of steps: " + (steps != null ? Integer.valueOf(steps.size()) : null)));
        }
        return steps;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        throw new UnsupportedOperationException();
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        throw new UnsupportedOperationException();
    }

    protected JBPMWorkflowManager getWorkflowManager() {
        return this.workflowManager;
    }
}

