/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.common.jbossas;

import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerMessageLog;
import com.jboss.jbossnetwork.product.jbpm.handlers.BaseHandler;
import com.jboss.jbossnetwork.product.jbpm.handlers.ControlActionFacade;
import com.jboss.jbossnetwork.product.jbpm.handlers.SoftwareValue;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.common.jbossas.JBossASPaths;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.instantiation.Delegation;
import org.jbpm.instantiation.FieldInstantiator;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.content.ContentContext;

public class JBPMWorkflowManager {
    private ContentContext contentContext;
    private ControlActionFacade controlFacade;
    private JBossASPaths jbossPaths;
    private final Log log = LogFactory.getLog(this.getClass());

    public JBPMWorkflowManager(ContentContext contentContext, ControlActionFacade controlFacade, JBossASPaths jbossPaths) {
        this.contentContext = contentContext;
        this.controlFacade = controlFacade;
        this.jbossPaths = jbossPaths;
    }

    public DeployIndividualPackageResponse run(ResourcePackageDetails packageDetails) throws Exception {
        this.checkCompatibility(packageDetails);
        byte[] metadataBytes = packageDetails.getMetadata();
        if (metadataBytes == null) {
            throw new IllegalArgumentException("The 'metadata' field of the 'packageDetails' parameter is null.");
        }
        String process = new String(metadataBytes);
        List<DeployPackageStep> unexecutedSteps = this.translateSteps(packageDetails);
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlString((String)process);
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        ContextInstance context = processInstance.getContextInstance();
        context.setVariable("contentContext", (Object)this.contentContext);
        context.setVariable("controlActionFacade", (Object)this.controlFacade);
        context.setVariable("packageDetailsKey", (Object)packageDetails.getKey());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date timestamp = new Date();
        String formattedTimestamp = format.format(timestamp);
        context.setVariable("timestamp", (Object)formattedTimestamp);
        try {
            File patchDir;
            File downloadDir = this.createTempDir("jon_download");
            if (downloadDir != null) {
                context.setVariable("downloadFolder", (Object)downloadDir.getAbsolutePath());
            }
            if ((patchDir = this.createTempDir("jon_patch")) != null) {
                context.setVariable("patchFolder", (Object)patchDir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Error creating temporary directories", (Throwable)e);
        }
        String jbossHomeDir = this.jbossPaths.getHomeDir();
        this.log.debug((Object)("jbossHomeDir: " + (jbossHomeDir == null ? " is NULL" : jbossHomeDir)));
        jbossHomeDir = jbossHomeDir + File.separator;
        context.setVariable("jbossHomeDir", (Object)jbossHomeDir);
        String jbossClientDir = jbossHomeDir + File.separator + "client" + File.separator;
        this.log.debug((Object)("jbossClientDir: " + jbossClientDir));
        context.setVariable("jbossClientDir", (Object)jbossClientDir);
        String jbossServerDir = this.jbossPaths.getServerDir();
        this.log.debug((Object)("jbossServerDir: " + (jbossServerDir == null ? " is NULL" : jbossServerDir)));
        jbossServerDir = jbossServerDir + File.separator;
        context.setVariable("jbossServerHomeDir", (Object)jbossServerDir);
        SoftwareValue softwareValue = this.resourcePackageDetailsToSoftwareValue(packageDetails);
        context.setVariable("software", (Object)softwareValue);
        try {
            processInstance.signal();
        }
        catch (Exception e) {
            this.log.error((Object)"Error received from the workflow", (Throwable)e);
        }
        List logs = processInstance.getLoggingInstance().getLogs();
        DeployIndividualPackageResponse response = this.parseLogs(logs, unexecutedSteps, packageDetails.getKey());
        return response;
    }

    public List<DeployPackageStep> translateSteps(ResourcePackageDetails packageDetails) throws Exception {
        this.checkCompatibility(packageDetails);
        byte[] metadataBytes = packageDetails.getMetadata();
        if (metadataBytes == null) {
            return null;
        }
        String process = new String(metadataBytes);
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlString((String)process);
        SuperState mainProcess = (SuperState)processDefinition.getNode("main_process");
        if (mainProcess == null) {
            this.log.warn((Object)("Could not retrieve main process for package [" + packageDetails + "]"));
            return null;
        }
        ArrayList<DeployPackageStep> steps = new ArrayList<DeployPackageStep>();
        List nodes = mainProcess.getNodes();
        for (Node node : nodes) {
            Action action = node.getAction();
            if (action == null) continue;
            Delegation delegation = action.getActionDelegation();
            String configProps = delegation.getConfiguration();
            String actionHandlerClassName = delegation.getClassName();
            FieldInstantiator instantiator = new FieldInstantiator();
            BaseHandler handler = (BaseHandler)instantiator.instantiate(Class.forName(actionHandlerClassName), configProps);
            handler.setPropertyDefaults();
            String description = handler.getDescription();
            DeployPackageStep step = new DeployPackageStep(node.getName(), description);
            step.setStepResult(ContentResponseResult.NOT_PERFORMED);
            steps.add(step);
        }
        return steps;
    }

    private DeployIndividualPackageResponse parseLogs(List logs, List<DeployPackageStep> unexecutedSteps, PackageDetailsKey packageDetailsKey) {
        ArrayList<DeployPackageStep> steps = new ArrayList<DeployPackageStep>();
        ContentResponseResult overallResult = ContentResponseResult.SUCCESS;
        for (Object uncastedLog : logs) {
            boolean unexecutedStepDeleted;
            if (!(uncastedLog instanceof ActionHandlerMessageLog)) continue;
            ActionHandlerMessageLog messageLog = (ActionHandlerMessageLog)((Object)uncastedLog);
            DeployPackageStep executedStep = messageLog.getStep();
            steps.add(executedStep);
            if (this.log.isDebugEnabled()) {
                String executedStepKey = executedStep.getStepKey();
                DeployPackageStep unexecutedStep = null;
                for (DeployPackageStep s : unexecutedSteps) {
                    if (!s.getStepKey().equals(executedStepKey)) continue;
                    unexecutedStep = s;
                    break;
                }
                if (unexecutedStep != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Mapped up steps:");
                    this.log.debug((Object)("Executed Step: " + executedStep));
                    this.log.debug((Object)("Unexecuted Step: " + unexecutedStep));
                }
            }
            if (!(unexecutedStepDeleted = unexecutedSteps.remove(executedStep))) {
                this.log.warn((Object)("Could not remove the following step from the unexecuted step list: " + executedStep));
            }
            if (executedStep.getStepResult() != ContentResponseResult.FAILURE) continue;
            overallResult = ContentResponseResult.FAILURE;
        }
        for (DeployPackageStep unexecutedStep : unexecutedSteps) {
            unexecutedStep.setStepResult(ContentResponseResult.NOT_PERFORMED);
            steps.add(unexecutedStep);
        }
        DeployIndividualPackageResponse response = new DeployIndividualPackageResponse(packageDetailsKey, overallResult);
        response.setDeploymentSteps(steps);
        return response;
    }

    private File createTempDir(String prefix) throws IOException {
        File tmpDir = File.createTempFile(prefix, "", null);
        boolean deleteSuccessful = tmpDir.delete();
        boolean mkdirSuccessful = tmpDir.mkdirs();
        if (deleteSuccessful && mkdirSuccessful) {
            return tmpDir;
        }
        return null;
    }

    private void checkCompatibility(ResourcePackageDetails packageDetails) {
        Configuration extraProperties = packageDetails.getExtraProperties();
        String compatibilityVersion = this.safeGet(extraProperties, "instructionCompatibilityVersion");
        if (compatibilityVersion != null && !compatibilityVersion.equals("1.4")) {
            throw new UnsupportedOperationException("Instruction set for this package is not supported. Version: " + compatibilityVersion);
        }
    }

    private SoftwareValue resourcePackageDetailsToSoftwareValue(ResourcePackageDetails pkg) {
        Configuration extraProperties = pkg.getExtraProperties();
        SoftwareValue softwareValue = new SoftwareValue();
        softwareValue.setDownloadUrl(pkg.getLocation());
        softwareValue.setFilename(pkg.getFileName());
        softwareValue.setFileSize(pkg.getFileSize());
        softwareValue.setInstructionCompatibilityVersion(this.safeGet(extraProperties, "instructionCompatibilityVersion"));
        softwareValue.setIssueReference(this.safeGet(extraProperties, "jiraId"));
        softwareValue.setLicenseName(pkg.getLicenseName());
        softwareValue.setLicenseVersion(pkg.getLicenseVersion());
        softwareValue.setLongDescription(pkg.getLongDescription());
        softwareValue.setMD5(pkg.getMD5());
        softwareValue.setSHA256(pkg.getSHA256());
        softwareValue.setShortDescription(pkg.getShortDescription());
        softwareValue.setTitle(pkg.getName());
        return softwareValue;
    }

    private String safeGet(Configuration configuration, String key) {
        if (configuration == null) {
            return null;
        }
        PropertySimple simple = configuration.getSimple(key);
        return simple != null ? simple.getStringValue() : null;
    }
}

