/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.pluginGen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceCategory {
    PLATFORM('P'),
    SERVER('S'),
    SERVICE('I');

    char abbrevLetter;
    private static Map<ResourceCategory, List<ResourceCategory>> enumMap;

    private ResourceCategory(char abbrev) {
        this.abbrevLetter = abbrev;
    }

    public static List<ResourceCategory> getPossibleChildren(ResourceCategory parent) {
        if (parent == null) {
            return enumMap.get((Object)PLATFORM);
        }
        return enumMap.get((Object)parent);
    }

    public char getAbbrev() {
        return this.abbrevLetter;
    }

    public static ResourceCategory getByAbbrv(char abbrev) {
        EnumSet<ResourceCategory> set = EnumSet.allOf(ResourceCategory.class);
        for (ResourceCategory cat : set) {
            if (cat.getAbbrev() != abbrev) continue;
            return cat;
        }
        return null;
    }

    public String getLowerName() {
        return this.toString().toLowerCase(Locale.getDefault());
    }

    static {
        enumMap = new EnumMap<ResourceCategory, List<ResourceCategory>>(ResourceCategory.class);
        for (ResourceCategory cat : ResourceCategory.values()) {
            ArrayList<ResourceCategory> catList = new ArrayList<ResourceCategory>();
            switch (cat) {
                case PLATFORM: {
                    catList.addAll(Arrays.asList(PLATFORM, SERVER, SERVICE));
                    break;
                }
                case SERVER: {
                    catList.addAll(Arrays.asList(SERVER, SERVICE));
                    break;
                }
                case SERVICE: {
                    catList.addAll(Arrays.asList(SERVICE));
                }
            }
            enumMap.put(cat, catList);
        }
    }
}

