/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.rest;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rhq.enterprise.rest.JsonPFilter;

public class JsonPFilter
implements Filter {
    private static final String APPLICATION_JSON = "application/json";
    private static final String VND_RHQ_WRAPPED_JSON = "application/vnd.rhq.wrapped+json";
    private static final String ACCEPT = "accept";
    private String callbackName;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.hasCallback((ServletRequest)httpRequest)) {
            String callback = this.getCallback(httpRequest);
            JsonPRequestWrapper requestWrapper = new JsonPRequestWrapper(httpRequest);
            if (this.requestsJsonWrapping(httpRequest)) {
                requestWrapper.setHeader(ACCEPT, VND_RHQ_WRAPPED_JSON);
            } else {
                requestWrapper.setHeader(ACCEPT, APPLICATION_JSON);
            }
            requestWrapper.setContentType(APPLICATION_JSON);
            JsonPResponseWrapper responseWrapper = new JsonPResponseWrapper(httpResponse, null);
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            response.setContentType("application/javascript; charset=utf-8");
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write((callback + "(").getBytes());
            responseWrapper.getByteArrayOutputStream().writeTo((OutputStream)outputStream);
            outputStream.write(");".getBytes());
            outputStream.flush();
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean requestsJsonWrapping(HttpServletRequest httpRequest) {
        String mimeType = httpRequest.getHeader(ACCEPT);
        if (mimeType.equals(VND_RHQ_WRAPPED_JSON)) {
            return true;
        }
        String localPart = httpRequest.getContextPath();
        return localPart.endsWith(".jsonw");
    }

    public void init(FilterConfig config) throws ServletException {
        this.callbackName = config.getInitParameter("filter.jsonp.callback");
    }

    private boolean hasCallback(ServletRequest request) {
        String cb = request.getParameter(this.callbackName);
        return cb != null && !cb.isEmpty();
    }

    private String getCallback(HttpServletRequest request) {
        return request.getParameter(this.callbackName);
    }
}

