/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.rest;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rhq.enterprise.rest.JsonPFilter;

public class JsonPFilter
implements Filter {
    private String callbackName;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("This filter can  only process HttpServletRequest requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.hasCallback((ServletRequest)httpRequest)) {
            String callback = this.getCallback(httpRequest);
            JsonPRequestWrapper requestWrapper = new JsonPRequestWrapper(httpRequest);
            requestWrapper.setHeader("accept", "application/json");
            requestWrapper.setContentType("application/json");
            JsonPResponseWrapper responseWrapper = new JsonPResponseWrapper(httpResponse, null);
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            response.setContentType("application/javascript; charset=utf-8");
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write((callback + "(").getBytes());
            responseWrapper.getByteArrayOutputStream().writeTo((OutputStream)outputStream);
            outputStream.write(");".getBytes());
            outputStream.flush();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.callbackName = config.getInitParameter("filter.jsonp.callback");
    }

    private boolean hasCallback(ServletRequest request) {
        String cb = request.getParameter(this.callbackName);
        return cb != null && !cb.isEmpty();
    }

    private String getCallback(HttpServletRequest request) {
        return request.getParameter(this.callbackName);
    }
}

