/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.clientapi.server.plugin.content.ContentSourceAdapter;
import org.rhq.core.clientapi.server.plugin.content.ContentSourcePackageDetails;
import org.rhq.core.clientapi.server.plugin.content.ContentSourcePackageDetailsKey;
import org.rhq.core.clientapi.server.plugin.content.PackageSyncReport;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.util.MD5Generator;
import org.rhq.core.util.file.ContentFileInfo;
import org.rhq.core.util.file.ContentFileInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskSource
implements ContentSourceAdapter {
    private File rootDirectory;
    private String rootDirectoryAbsolutePath;
    private Map<String, SupportedPackageType> supportedPackageTypes;

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    protected void setRootDirectory(File path) {
        this.rootDirectory = path;
        this.rootDirectoryAbsolutePath = this.rootDirectory.getAbsolutePath();
    }

    protected Map<String, SupportedPackageType> getSupportedPackageTypes() {
        return this.supportedPackageTypes;
    }

    protected void setSupportedPackageTypes(Map<String, SupportedPackageType> supportedPackageTypes) {
        this.supportedPackageTypes = supportedPackageTypes;
    }

    public void initialize(Configuration configuration) throws Exception {
        this.initializePackageTypes(configuration);
        String pathString = configuration.getSimpleValue("rootDirectory", null);
        this.setRootDirectory(new File(pathString));
        this.testConnection();
    }

    public void shutdown() {
        this.rootDirectory = null;
        this.rootDirectoryAbsolutePath = null;
        this.supportedPackageTypes = null;
    }

    public void synchronizePackages(PackageSyncReport report, Collection<ContentSourcePackageDetails> existingPackages) throws Exception {
        ArrayList<ContentSourcePackageDetails> deletedPackages = new ArrayList<ContentSourcePackageDetails>();
        deletedPackages.addAll(existingPackages);
        long before = System.currentTimeMillis();
        this.syncPackages(report, deletedPackages, this.getRootDirectory());
        long elapsed = System.currentTimeMillis() - before;
        for (ContentSourcePackageDetails p : deletedPackages) {
            report.addDeletePackage(p);
        }
        report.setSummary("Synchronized [" + this.getRootDirectory() + "]. Elapsed time=[" + elapsed + "] ms");
    }

    public void testConnection() throws Exception {
        File root = this.getRootDirectory();
        if (!root.exists()) {
            throw new Exception("Disk source [" + root + "] does not exist");
        }
        if (!root.canRead()) {
            throw new Exception("Not permitted to read disk source [" + root + "] ");
        }
        if (!root.isDirectory()) {
            throw new Exception("Disk source [" + root + "] is not a directory");
        }
    }

    public InputStream getInputStream(String location) throws Exception {
        return new FileInputStream(new File(this.getRootDirectory(), location));
    }

    protected void syncPackages(PackageSyncReport report, List<ContentSourcePackageDetails> packages, File directory) throws Exception {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.syncPackages(report, packages, file);
                continue;
            }
            ContentSourcePackageDetails details = this.createPackage(file);
            if (details == null) continue;
            ContentSourcePackageDetails existing = this.findPackage(packages, details);
            if (existing == null) {
                report.addNewPackage(details);
                continue;
            }
            packages.remove(existing);
            if (details.getFileCreatedDate().compareTo(existing.getFileCreatedDate()) <= 0) continue;
            report.addUpdatedPackage(details);
        }
    }

    protected ContentSourcePackageDetails createPackage(File file) throws Exception {
        SupportedPackageType supportedPackageType = this.determinePackageType(file);
        if (supportedPackageType == null) {
            return null;
        }
        ContentFileInfo fileInfo = ContentFileInfoFactory.createContentFileInfo((File)file);
        String md5 = MD5Generator.getDigestString((File)file);
        String name = file.getName();
        String version = fileInfo.getVersion(md5);
        String packageTypeName = supportedPackageType.packageTypeName;
        String architectureName = supportedPackageType.architectureName;
        String resourceTypeName = supportedPackageType.resourceTypeName;
        String resourceTypePluginName = supportedPackageType.resourceTypePluginName;
        ContentSourcePackageDetailsKey key = new ContentSourcePackageDetailsKey(name, version, packageTypeName, architectureName, resourceTypeName, resourceTypePluginName);
        ContentSourcePackageDetails pkg = new ContentSourcePackageDetails(key);
        pkg.setDisplayName(name);
        pkg.setFileName(name);
        pkg.setFileCreatedDate(Long.valueOf(file.lastModified()));
        pkg.setFileSize(Long.valueOf(file.length()));
        pkg.setMD5(md5);
        pkg.setLocation(this.getRelativePath(file));
        pkg.setShortDescription(fileInfo.getDescription(null));
        return pkg;
    }

    protected ContentSourcePackageDetails findPackage(List<ContentSourcePackageDetails> packages, ContentSourcePackageDetails pkg) {
        for (ContentSourcePackageDetails p : packages) {
            if (!p.equals((Object)pkg)) continue;
            return p;
        }
        return null;
    }

    protected String getRelativePath(File file) {
        String relativePath;
        String fileAbsolutePath = file.getAbsolutePath();
        int idx = fileAbsolutePath.indexOf(this.rootDirectoryAbsolutePath);
        if (idx > -1) {
            relativePath = fileAbsolutePath.substring(idx + this.rootDirectoryAbsolutePath.length());
            if (relativePath.startsWith(File.separator)) {
                relativePath = relativePath.substring(1);
            }
        } else {
            relativePath = fileAbsolutePath;
        }
        return relativePath;
    }

    protected void initializePackageTypes(Configuration config) {
        HashMap<String, SupportedPackageType> supportedPackageTypes = new HashMap<String, SupportedPackageType>();
        SupportedPackageType supportedPackageType = new SupportedPackageType();
        supportedPackageType.packageTypeName = config.getSimpleValue("packageTypeName", null);
        supportedPackageType.architectureName = config.getSimpleValue("architectureName", null);
        supportedPackageType.resourceTypeName = config.getSimpleValue("resourceTypeName", null);
        supportedPackageType.resourceTypePluginName = config.getSimpleValue("resourceTypePluginName", null);
        String filenameFilter = config.getSimpleValue("filenameFilter", null);
        supportedPackageTypes.put(filenameFilter, supportedPackageType);
        this.setSupportedPackageTypes(supportedPackageTypes);
    }

    protected SupportedPackageType determinePackageType(File file) {
        String absolutePath = file.getAbsolutePath();
        for (Map.Entry<String, SupportedPackageType> entry : this.getSupportedPackageTypes().entrySet()) {
            if (!absolutePath.matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    protected class SupportedPackageType {
        public String packageTypeName;
        public String architectureName;
        public String resourceTypeName;
        public String resourceTypePluginName;

        protected SupportedPackageType() {
        }
    }
}

