/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.DomainBlockStats;
import org.libvirt.DomainInfo;
import org.libvirt.DomainInterfaceStats;
import org.libvirt.LibvirtException;
import org.libvirt.Network;
import org.libvirt.NodeInfo;
import org.libvirt.jna.Libvirt;
import org.rhq.plugins.virt.Logger;

public class LibVirtConnection {
    private static int SUCCESS = 0;
    private Connect connection;
    private Log log = LogFactory.getLog(LibVirtConnection.class);
    private boolean connected = false;

    public LibVirtConnection(String uri) throws LibvirtException {
        try {
            Connect.setErrorCallback((Libvirt.VirErrorCallback)Logger.INSTANCE);
            this.connection = new Connect(uri);
            this.connected = true;
            this.connection.setConnectionErrorCallback((Libvirt.VirErrorCallback)Logger.INSTANCE);
        }
        catch (LibvirtException e) {
            this.log.warn((Object)"Can not obtain an instance of libvirt");
            this.connection = null;
            throw e;
        }
        finally {
            Connect.setErrorCallback(null);
        }
    }

    public String getConnectionURI() throws LibvirtException {
        return this.connection.getURI();
    }

    public List<String> getDomainNames() throws LibvirtException {
        if (this.connection == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(this.connection.listDefinedDomains());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.connected) {
            this.connection.close();
            this.connected = false;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int[] getDomainIds() throws Exception {
        if (this.connection == null) {
            return new int[0];
        }
        return this.connection.listDomains();
    }

    public void printDomainInfo(DomainInfo domainInfo) {
        System.out.println("\tDOMAIN INFO: \n\tstate=" + String.valueOf(domainInfo.domainInfo.state) + "\n\tmem=" + domainInfo.domainInfo.maxMem + "\n\tfree=" + domainInfo.domainInfo.memory + "\n\tCPUs=" + domainInfo.domainInfo.nrVirtCpu + "\n\tcpu=" + domainInfo.domainInfo.cpuTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainInfo getDomainInfo(String domainName) throws LibvirtException {
        DomainInfo domainInfo;
        Domain domain = this.getDomain(domainName);
        try {
            DomainInfo info = new DomainInfo();
            info.domainInfo = domain.getInfo();
            info.name = domainName;
            info.uuid = domain.getUUIDString();
            domainInfo = info;
        }
        catch (Throwable throwable) {
            try {
                domain.free();
                throw throwable;
            }
            catch (LibvirtException e) {
                this.log.error((Object)("Error looking up domain with name " + domainName), (Throwable)e);
                throw e;
            }
        }
        domain.free();
        return domainInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainInfo getDomainInfo(int id) throws LibvirtException {
        DomainInfo domainInfo;
        Domain domain = this.connection.domainLookupByID(id);
        if (domain == null) {
            throw new IllegalArgumentException("No domain found with ID: " + id);
        }
        try {
            DomainInfo info = new DomainInfo();
            info.domainInfo = domain.getInfo();
            info.name = domain.getName();
            info.uuid = domain.getUUIDString();
            domainInfo = info;
        }
        catch (Throwable throwable) {
            try {
                domain.free();
                throw throwable;
            }
            catch (LibvirtException e) {
                this.log.error((Object)("Error looking up domain with id " + id), (Throwable)e);
                throw e;
            }
        }
        domain.free();
        return domainInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDomainXML(String domainName) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            String string = domain.getXMLDesc(0);
            return string;
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int domainReboot(String domainName) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.reboot(0);
            int n = SUCCESS;
            return n;
        }
        finally {
            domain.free();
        }
    }

    public int domainRestore(String toPath) throws LibvirtException {
        this.connection.restore(toPath);
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int domainDestroy(String domainName) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.destroy();
            int n = SUCCESS;
            return n;
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int domainDelete(String domainName) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            DomainInfo.DomainState state = domain.getInfo().state;
            if (state != DomainInfo.DomainState.VIR_DOMAIN_SHUTDOWN && state != DomainInfo.DomainState.VIR_DOMAIN_SHUTOFF) {
                domain.destroy();
            }
            domain.undefine();
            int n = SUCCESS;
            return n;
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int domainSave(String domainName, String toPath) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.save(toPath);
            int n = SUCCESS;
            return n;
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int domainResume(String domainName) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.resume();
            int n = SUCCESS;
            return n;
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int domainShutdown(String domainName) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.shutdown();
            int n = SUCCESS;
            return n;
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int domainSuspend(String domainName) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.suspend();
            int n = SUCCESS;
            return n;
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int domainCreate(String domainName) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.create();
            int n = SUCCESS;
            return n;
        }
        finally {
            domain.free();
        }
    }

    public boolean defineDomain(String xml) throws LibvirtException {
        boolean returnValue;
        Domain dom = this.connection.domainDefineXML(xml);
        boolean bl = returnValue = dom != null;
        if (returnValue) {
            dom.free();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxMemory(String domainName, long size) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.setMaxMemory(size);
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemory(String domainName, long size) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.setMemory(size);
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVcpus(String domainName, int count) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            domain.setVcpus(count);
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainInterfaceStats getDomainInterfaceStats(String domainName, String path) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            DomainInterfaceStats domainInterfaceStats = domain.interfaceStats(path);
            return domainInterfaceStats;
        }
        finally {
            domain.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainBlockStats getDomainBlockStats(String domainName, String path) throws LibvirtException {
        Domain domain = this.getDomain(domainName);
        try {
            DomainBlockStats domainBlockStats = domain.blockStats(path);
            return domainBlockStats;
        }
        finally {
            domain.free();
        }
    }

    public int close() throws LibvirtException {
        if (this.connected) {
            this.connected = false;
            return this.connection.close();
        }
        return 0;
    }

    public double getMemoryPercentage() throws LibvirtException {
        double memory = this.connection.nodeInfo().memory;
        double usedMemory = 0.0;
        for (int id : this.connection.listDomains()) {
            Domain domain = this.connection.domainLookupByID(id);
            if (domain == null) continue;
            usedMemory += (double)domain.getInfo().memory;
            domain.free();
        }
        return usedMemory / memory;
    }

    public long getCPUTime() throws LibvirtException {
        long cpuTime = 0L;
        for (int id : this.connection.listDomains()) {
            Domain domain = this.connection.domainLookupByID(id);
            if (domain == null) continue;
            cpuTime += domain.getInfo().cpuTime;
            domain.free();
        }
        return cpuTime;
    }

    public HVInfo getHVInfo() throws LibvirtException {
        HVInfo hvInfo = new HVInfo();
        hvInfo.libvirtVersion = this.connection.getLibVirVersion();
        hvInfo.hvType = this.connection.getType();
        hvInfo.uri = this.connection.getURI();
        hvInfo.version = this.connection.getVersion();
        hvInfo.hostname = this.connection.getHostName();
        hvInfo.nodeInfo = this.connection.nodeInfo();
        return hvInfo;
    }

    public List<String> getNetworks() throws LibvirtException {
        if (this.connection == null) {
            return Arrays.asList(new String[0]);
        }
        return Arrays.asList(this.connection.listNetworks());
    }

    public List<String> getDefinedNetworks() throws LibvirtException {
        if (this.connection == null) {
            return Arrays.asList(new String[0]);
        }
        return Arrays.asList(this.connection.listDefinedNetworks());
    }

    public boolean isNetworkActive(String name) throws LibvirtException {
        return this.getNetworks().contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkInfo getNetwork(String name) throws LibvirtException {
        Network net = this.getLibVirtNetwork(name);
        try {
            NetworkInfo info = new NetworkInfo();
            info.name = net.getName();
            info.autostart = net.getAutostart();
            info.bridgeName = net.getBridgeName();
            NetworkInfo networkInfo = info;
            return networkInfo;
        }
        finally {
            net.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNetworkXML(String name) throws LibvirtException {
        Network network = this.getLibVirtNetwork(name);
        try {
            String string = network.getXMLDesc(0);
            return string;
        }
        finally {
            network.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNetwork(String name, String xml, boolean autostart) throws LibvirtException {
        this.connection.networkDefineXML(xml);
        Network network = this.getLibVirtNetwork(name);
        try {
            network.setAutostart(autostart);
        }
        finally {
            network.free();
        }
    }

    public static void main(String[] args) throws Exception {
        LibVirtConnection conn = new LibVirtConnection("");
        HVInfo hi = conn.getHVInfo();
        System.out.println("HV Version:" + hi.version);
        System.out.println("LV Version:" + hi.libvirtVersion);
        System.out.println("HV Type:" + hi.hvType);
        System.out.println("HV URI:" + hi.uri);
        for (int foo : conn.getDomainIds()) {
            System.out.println(foo);
            System.out.println(conn.connection.domainLookupByID(foo).interfaceStats(""));
        }
        for (String foo : conn.getDomainNames()) {
            System.out.println(foo);
            System.out.println(conn.connection.domainLookupByName(foo).getXMLDesc(0));
        }
    }

    private Domain getDomain(String domainName) throws LibvirtException, IllegalArgumentException {
        Domain ret = this.connection.domainLookupByName(domainName);
        if (ret == null) {
            throw new IllegalArgumentException("Could not find a domain called '" + domainName + "'.");
        }
        return ret;
    }

    private Network getLibVirtNetwork(String networkName) throws LibvirtException, IllegalArgumentException {
        Network ret = this.connection.networkLookupByName(networkName);
        if (ret == null) {
            throw new IllegalArgumentException("Could not find a netword called '" + networkName + "'.");
        }
        return ret;
    }

    public static class HVInfo {
        public long libvirtVersion;
        public String hvType;
        public String uri;
        public String hostname;
        public long version;
        public NodeInfo nodeInfo;
    }

    public static class NetworkInfo {
        public String name;
        public boolean autostart;
        public String bridgeName;
    }

    public static class DomainInfo {
        public int id;
        public String name;
        public String uuid;
        public org.libvirt.DomainInfo domainInfo;
    }
}

