/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.virt.LibVirtConnection;

public class VirtualizationHostDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        DiscoveredResourceDetails detail = this.getResource(resourceDiscoveryContext.getResourceType(), resourceDiscoveryContext.getDefaultPluginConfiguration());
        if (detail != null) {
            details.add(detail);
        }
        return details;
    }

    DiscoveredResourceDetails getResource(ResourceType type, Configuration config) {
        DiscoveredResourceDetails res = null;
        try {
            String uri = config.getSimpleValue("connectionURI", "");
            LibVirtConnection virt = new LibVirtConnection(uri);
            LibVirtConnection.HVInfo hi = virt.getHVInfo();
            res = new DiscoveredResourceDetails(type, "VirtHost." + hi.hostname, hi.hvType + " Hypervisor", "" + hi.version, String.format("Libvirt Connection to a %s hypervisor", hi.hvType), null, null);
            res.getPluginConfiguration().put((Property)new PropertySimple("connectionURI", (Object)virt.getConnectionURI()));
            virt.close();
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (t.getCause() != null) {
                message = message + ": " + t.getCause().getMessage();
            }
            this.log.warn((Object)("Can not load libvirt: " + message));
        }
        return res;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext context) throws InvalidPluginConfigurationException {
        return this.getResource(context.getResourceType(), pluginConfiguration);
    }
}

