/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libvirt.LibvirtException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.virt.LibVirtConnection;
import org.rhq.plugins.virt.VirtualizationDomainComponent;

public class VirtualizationHostComponent
implements ResourceComponent<ResourceComponent<?>>,
MeasurementFacet,
ConfigurationFacet,
CreateChildResourceFacet {
    private Log log = LogFactory.getLog(VirtualizationDomainComponent.class);
    private String uri = "";
    private LibVirtConnection virt;
    private long cpuNanosLast;
    private long cpuCheckedLast;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.uri = resourceContext.getPluginConfiguration().getSimpleValue("connectionURI", "");
        this.virt = new LibVirtConnection(this.uri);
        if (!this.virt.isConnected()) {
            this.virt = null;
        }
    }

    public void stop() {
        try {
            this.virt.close();
        }
        catch (Exception e) {
            this.log.error((Object)"Exception Stopping Libvirt", (Throwable)e);
        }
    }

    public AvailabilityType getAvailability() {
        if (this.virt.isConnected()) {
            try {
                this.virt.getHVInfo();
                return AvailabilityType.UP;
            }
            catch (Exception e) {
                return AvailabilityType.DOWN;
            }
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        if (this.virt.isConnected()) {
            LibVirtConnection.HVInfo hi = this.virt.getHVInfo();
            for (MeasurementScheduleRequest request : metrics) {
                if (request.getName().equals("cpus")) {
                    report.addData(new MeasurementDataTrait(request, "" + hi.nodeInfo.cpus));
                    continue;
                }
                if (request.getName().equals("memory")) {
                    report.addData(new MeasurementDataTrait(request, "" + hi.nodeInfo.memory));
                    continue;
                }
                if (request.getName().equals("memoryUsage")) {
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(this.virt.getMemoryPercentage())));
                    continue;
                }
                if (request.getName().equals("cpuUsage")) {
                    long checked = System.nanoTime();
                    long cpuNanos = this.virt.getCPUTime();
                    if (this.cpuCheckedLast != 0L) {
                        long duration = checked - this.cpuCheckedLast;
                        long diff = cpuNanos - this.cpuNanosLast;
                        double percentage = (double)diff / (double)duration;
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(percentage)));
                    }
                    this.cpuCheckedLast = checked;
                    this.cpuNanosLast = cpuNanos;
                    continue;
                }
                if (!request.getName().equals("cpuTime")) continue;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(this.virt.getCPUTime())));
            }
        }
    }

    public Configuration loadResourceConfiguration() throws LibvirtException {
        Configuration config = new Configuration();
        if (this.virt.isConnected()) {
            LibVirtConnection.HVInfo info = this.virt.getHVInfo();
            config.put((Property)new PropertySimple("hypervisorType", (Object)info.hvType));
            config.put((Property)new PropertySimple("hostName", (Object)info.hostname));
            config.put((Property)new PropertySimple("libvirtVersion", (Object)this.getLibvirtVersion(info.libvirtVersion)));
        }
        return config;
    }

    public String getLibvirtVersion(long version) {
        long major = version / 1000000L;
        long remainder = version % 1000000L;
        long minor = remainder / 1000L;
        long micro = remainder % 1000L;
        return major + "." + minor + "." + micro;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        return report;
    }

    public LibVirtConnection getConnection() throws LibvirtException {
        return this.virt;
    }
}

