/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.richfaces.cdk.As;
import org.richfaces.cdk.AsProvider;
import org.richfaces.cdk.Implementation;
import org.richfaces.cdk.Mock;
import org.richfaces.cdk.MockController;
import org.richfaces.cdk.Stub;

public class CdkTestRunner
extends BlockJUnit4ClassRunner {
    public CdkTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Set<Field> getFields(Class<?> c) {
        HashSet<Field> fields = new HashSet<Field>(Arrays.asList(c.getDeclaredFields()));
        while ((c = c.getSuperclass()) != null) {
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isPrivate(f.getModifiers())) continue;
                fields.add(f);
            }
        }
        return fields;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        super.runChild(method, notifier);
    }

    protected Object createTest() throws Exception {
        Class c = this.getTestClass().getJavaClass();
        Set<Field> testFields = this.getFields(c);
        Map<Field, Binding> fieldValues = this.getMockValues(testFields);
        Object test = this.createTest(c, fieldValues);
        for (Field field : fieldValues.keySet()) {
            Binding binding = fieldValues.get(field);
            field.setAccessible(true);
            if (null == binding.getValue() || field.get(test) != null) continue;
            field.set(test, binding.getValue());
        }
        return test;
    }

    private Object createTest(Class<?> testClass, Map<Field, Binding> fieldValues) throws Exception {
        FieldModule fields = new FieldModule(fieldValues);
        Injector injector = Module.class.isAssignableFrom(testClass) ? Guice.createInjector((Module[])new Module[]{fields, (Module)testClass.newInstance()}) : Guice.createInjector((Module[])new Module[]{fields});
        return injector.getInstance(testClass);
    }

    private Map<Field, Binding> getMockValues(Set<Field> testFields) {
        HashMap<Field, Binding> mocksAndStubs = new HashMap<Field, Binding>();
        for (Field field : testFields) {
            Binding bind;
            if (field.getAnnotation(Mock.class) != null) {
                bind = new Binding();
                bind.setValue(EasyMock.createStrictMock(field.getType()));
                mocksAndStubs.put(field, bind);
                continue;
            }
            if (field.getAnnotation(Stub.class) != null) {
                bind = new Binding();
                bind.setValue(EasyMock.createNiceMock(field.getType()));
                mocksAndStubs.put(field, bind);
                continue;
            }
            if (null != field.getAnnotation(As.class)) {
                bind = new Binding();
                bind.setImplementation(field.getAnnotation(As.class).value());
                mocksAndStubs.put(field, bind);
                continue;
            }
            if (null == field.getAnnotation(AsProvider.class)) continue;
            bind = new Binding();
            bind.setProvider(field.getAnnotation(AsProvider.class).value());
            mocksAndStubs.put(field, bind);
        }
        return mocksAndStubs;
    }

    protected static final class Binding {
        private Object value;
        private Class<?> implementation;
        private Class<? extends Provider<?>> provider;

        protected Binding() {
        }

        void setValue(Object value) {
            this.value = value;
        }

        Object getValue() {
            return this.value;
        }

        void setImplementation(Class<?> implementation) {
            this.implementation = implementation;
        }

        Class<?> getImplementation() {
            return this.implementation;
        }

        void setProvider(Class<? extends Provider<?>> provider) {
            this.provider = provider;
        }

        Class<? extends Provider<?>> getProvider() {
            return this.provider;
        }
    }

    protected static final class FieldModule
    extends AbstractModule
    implements MockController {
        final Map<Field, Binding> fields;

        public FieldModule(Map<Field, Binding> fields) {
            this.fields = fields;
        }

        protected void configure() {
            this.bind(MockController.class).toInstance((Object)this);
            for (Field field : this.fields.keySet()) {
                Annotation[] fieldAnnotations;
                TypeLiteral literal = TypeLiteral.get((Type)field.getGenericType());
                AnnotatedBindingBuilder builder = this.bind(literal);
                for (Annotation annotation : fieldAnnotations = field.getAnnotations()) {
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    if (!annotationType.isAnnotationPresent(BindingAnnotation.class)) continue;
                    Implementation implementation = annotationType.getAnnotation(Implementation.class);
                    if (null != implementation) {
                        try {
                            Annotation value = (Annotation)implementation.value().getConstructor(annotationType).newInstance(annotation);
                            builder.annotatedWith(value);
                            continue;
                        }
                        catch (SecurityException e) {
                            throw new RuntimeException(e);
                        }
                        catch (NoSuchMethodException e) {
                            builder.annotatedWith(annotationType);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    builder.annotatedWith(annotationType);
                }
                Binding binding = this.fields.get(field);
                if (null != binding.getValue()) {
                    builder.toInstance(binding.getValue());
                    continue;
                }
                if (null != binding.getImplementation()) {
                    builder.to(binding.getImplementation());
                    continue;
                }
                if (null == binding.getProvider()) continue;
                builder.toProvider(binding.getProvider());
            }
        }

        @Override
        public void replay() {
            for (Binding field : this.fields.values()) {
                if (null == field.getValue()) continue;
                EasyMock.replay((Object[])new Object[]{field.getValue()});
            }
        }

        @Override
        public void verify() {
            for (Binding field : this.fields.values()) {
                if (null == field.getValue()) continue;
                EasyMock.verify((Object[])new Object[]{field.getValue()});
            }
        }
    }
}

