/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.component.state;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ajax4jsf.builder.component.methods.VelocityMethodBody;
import org.ajax4jsf.builder.component.state.AttachedStateDescriptor;
import org.ajax4jsf.builder.component.state.ComponentStateDescriptor;
import org.ajax4jsf.builder.component.state.PrimitiveStateDescriptor;
import org.ajax4jsf.builder.component.state.SimplePropertyDescriptor;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.model.JavaClass;
import org.ajax4jsf.builder.model.JavaField;
import org.ajax4jsf.builder.model.JavaModifier;
import org.ajax4jsf.builder.model.MethodBody;

public class ComponentStateManager {
    private static final List<Class<?>> detached = new ArrayList<Class<?>>(){
        {
            this.add(String.class);
            this.add(Integer.class);
            this.add(Boolean.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(BigDecimal.class);
        }
    };
    private List<ComponentStateDescriptor> componentStates = new ArrayList<ComponentStateDescriptor>();

    public ComponentStateManager(JavaClass componentClass) {
        List<JavaField> fields = componentClass.getFields();
        for (JavaField javaField : fields) {
            this.registerField(javaField);
        }
    }

    public ComponentStateDescriptor getDesriptor(PropertyBean propertyBean, JavaField field) {
        Set<JavaModifier> modifiers = field.getModifiers();
        if (modifiers.contains((Object)JavaModifier.FINAL) || modifiers.contains((Object)JavaModifier.STATIC)) {
            return null;
        }
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            return new PrimitiveStateDescriptor(field);
        }
        if (detached.contains(type)) {
            return new SimplePropertyDescriptor(field);
        }
        return new AttachedStateDescriptor(field);
    }

    public void registerField(JavaField field) {
        ComponentStateDescriptor desriptor = this.getDesriptor(null, field);
        if (desriptor != null) {
            this.componentStates.add(desriptor);
        }
    }

    public MethodBody getSaveStateMethodBody(JSFGeneratorConfiguration configuration) throws GeneratorException {
        return new SaveStateMethodBody(configuration);
    }

    public MethodBody getRestoreStateMethodBody(JSFGeneratorConfiguration configuration) throws GeneratorException {
        return new RestoreStateMethodBody(configuration);
    }

    private class RestoreStateMethodBody
    extends VelocityMethodBody {
        public RestoreStateMethodBody(JSFGeneratorConfiguration configuration) throws GeneratorException {
            super(configuration);
            this.getContext().put("size", (Object)(ComponentStateManager.this.componentStates.size() + 1));
            this.getContext().put("descriptors", (Object)ComponentStateManager.this.componentStates);
        }

        public String getTemplate() {
            return "snippets/restore-state.vm";
        }
    }

    private class SaveStateMethodBody
    extends VelocityMethodBody {
        public SaveStateMethodBody(JSFGeneratorConfiguration configuration) throws GeneratorException {
            super(configuration);
            this.getContext().put("size", (Object)(ComponentStateManager.this.componentStates.size() + 1));
            this.getContext().put("descriptors", (Object)ComponentStateManager.this.componentStates);
        }

        public String getTemplate() {
            return "snippets/save-state.vm";
        }
    }
}

