/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.ajax4jsf.builder.config.LoaderHolder;
import org.ajax4jsf.builder.config.TestClassHolder;
import org.ajax4jsf.builder.generator.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfBean
implements LoaderHolder {
    private String _name;
    private String _displayname;
    private String _xmlEncodedDisplayname;
    private String _description;
    private String _xmlEncodedDescription;
    private String _icon;
    private String _classname;
    private String _superclass;
    private LoaderHolder _parent = null;
    private TestClassHolder _test;

    public TestClassHolder getTest() {
        return this._test;
    }

    public void setTest(TestClassHolder test) {
        this._test = test;
    }

    public String getClassname() {
        return this._classname;
    }

    public String getPackageName() {
        int lastPoint = this.getClassname().lastIndexOf(46);
        if (lastPoint > 0) {
            return this.getClassname().substring(0, lastPoint);
        }
        return "";
    }

    public String getSimpleClassName() {
        int lastPoint = this.getClassname().lastIndexOf(46);
        if (lastPoint > 0) {
            return this.getClassname().substring(lastPoint + 1);
        }
        return this.getClassname();
    }

    public List<JsfBean> getGenericTypes() {
        return Collections.emptyList();
    }

    public void setClassname(String classname) {
        this._classname = classname;
    }

    public String getDescription() {
        return this._description;
    }

    public String getXmlEncodedDescription() {
        return this._xmlEncodedDescription;
    }

    public void setDescription(String description) {
        this._description = description;
        this._xmlEncodedDescription = this.escapeXML(description);
    }

    public String getDisplayname() {
        return this._displayname;
    }

    public String getXmlEncodedDisplayname() {
        return this._xmlEncodedDisplayname;
    }

    public void setDisplayname(String displayName) {
        this._displayname = displayName;
        this._xmlEncodedDisplayname = this.escapeXML(displayName);
    }

    public String getIcon() {
        return this._icon;
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getSuperclass() {
        return this._superclass;
    }

    public void setSuperclass(String superclass) {
        this._superclass = superclass;
    }

    public boolean isInstanceof(String name) {
        String classname = this.getClassname();
        if (null == classname) {
            String msg = "classname not set in " + this.getClass().getName() + " for element " + this.getName();
            this.getLog().error(msg);
            throw new NullPointerException(msg);
        }
        if (classname.equals(name)) {
            return true;
        }
        try {
            Class<?> beanClass;
            try {
                beanClass = this.getLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                if (null == this.getSuperclass()) {
                    return false;
                }
                beanClass = this.getLoader().loadClass(this.getSuperclass());
            }
            Class<?> superClass = this.getLoader().loadClass(name);
            return superClass.isAssignableFrom(beanClass);
        }
        catch (ClassNotFoundException e) {
            this.getLog().warn("Could't instantiate for testing class " + classname);
        }
        catch (Exception e) {
            this.getLog().warn("Error in testing class " + classname);
            e.printStackTrace();
        }
        return false;
    }

    public boolean haveMethod(String name) {
        try {
            Class<?> beanClass;
            try {
                beanClass = this.getLoader().loadClass(this.getClassname());
            }
            catch (ClassNotFoundException e) {
                beanClass = this.getLoader().loadClass(this.getSuperclass());
            }
            Method[] methods = beanClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name) || Modifier.isAbstract(methods[i].getModifiers())) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().warn("Could't instantiate for testing class " + this.getClassname());
        }
        catch (Exception e) {
            this.getLog().warn("Error in testing class " + this.getClassname());
            e.printStackTrace();
        }
        return false;
    }

    public String escapeXML(String raw) {
        if (null != raw) {
            return raw.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;");
        }
        return null;
    }

    @Override
    public ClassLoader getLoader() {
        return this.getParent().getLoader();
    }

    @Override
    public Logger getLog() {
        return this.getParent().getLog();
    }

    @Override
    public void setLoader(ClassLoader loader) {
    }

    public LoaderHolder getParent() {
        return this._parent;
    }

    public void setParent(LoaderHolder parent) {
        this._parent = parent;
    }

    public String upperFirstChar(String name) {
        char[] charName = name.toCharArray();
        charName[0] = Character.toUpperCase(charName[0]);
        return new String(charName);
    }
}

