/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.RenderKitBean;
import org.ajax4jsf.builder.generator.XMLConfigGenerator;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigGenerator
extends XMLConfigGenerator {
    private static final String FACES_CONFIG_TEMPLATE_NAME = "faces-config.vm";
    private File _facesconfig = null;
    private List<RenderKitBean> renderKits = new ArrayList<RenderKitBean>();
    private ClassLoader _loader;

    public FacesConfigGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    @Override
    public void createFiles(BuilderConfig config) throws GeneratorException {
        VelocityContext context = new VelocityContext();
        Template template = this.getTemplate();
        this._loader = config.getLoader();
        context.put("components", config.getComponents());
        context.put("validators", config.getValidators());
        context.put("converters", config.getConverters());
        context.put("renderers", config.getRenderers());
        context.put("facesConfig", (Object)this);
        File configFile = this.getFacesconfig();
        File javaDir = configFile.getParentFile();
        if (!javaDir.exists()) {
            javaDir.mkdirs();
        }
        try {
            if (configFile.exists()) {
                configFile.delete();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(configFile));
            template.merge((Context)context, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (Exception e) {
            throw new GeneratorException("Error create new faces-config.xml ", e);
        }
    }

    @Override
    protected String getDefaultTemplateName() {
        return FACES_CONFIG_TEMPLATE_NAME;
    }

    public File getFacesconfig() {
        return this._facesconfig;
    }

    public void setFacesconfig(File taglib) {
        this._facesconfig = taglib;
    }

    public List<RenderKitBean> getRenderKits() {
        return this.renderKits;
    }

    public RenderKitBean createRenderKit() {
        RenderKitBean renderKit = new RenderKitBean();
        this.renderKits.add(renderKit);
        return renderKit;
    }

    public boolean rendererExists(String className) {
        boolean exists = false;
        try {
            Class.forName(className, false, this._loader);
            exists = true;
        }
        catch (Exception ex) {
            this.info("Class " + className + " not found, therefore not registered in faces-config");
        }
        return exists;
    }

    @Override
    protected String getRootTag() {
        return "faces-config";
    }
}

