/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ListenerBean;
import org.ajax4jsf.builder.config.TagBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ListenerTagGenerator
extends InnerGenerator {
    public ListenerTagGenerator(JSFGeneratorConfiguration config, Logger log) {
        super(config, log);
    }

    protected String getDefaultTemplateName() {
        return "listener_tag.vm";
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        VelocityContext context = new VelocityContext();
        Template template = this.getTemplate();
        List<ListenerBean> listeners = config.getListeners();
        for (ListenerBean bean : listeners) {
            TagBean tagHandler = bean.getTag();
            if (null == tagHandler || !tagHandler.isGenerate() || null == tagHandler.getClassname()) continue;
            context.put("tag", (Object)tagHandler);
            context.put("listener", (Object)bean);
            String resultPath = tagHandler.getClassname().replace('.', '/') + ".java";
            File javaFile = new File(this.getDestDir(), resultPath);
            File javaDir = javaFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            try {
                if (javaFile.exists()) {
                    javaFile.delete();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(javaFile));
                template.merge((Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error create new Listener JSP Tag Java file ", e);
            }
        }
    }
}

