/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.RendererBean;
import org.ajax4jsf.builder.generator.AbstractClassStubBuilder;
import org.ajax4jsf.builder.generator.FacesConfigGenerator;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.GetResourceInterceptor;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.RendererCompilationContext;
import org.ajax4jsf.builder.generator.ResourcesConfigGeneratorBean;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.builder.TemplateCompiler;
import org.ajax4jsf.templatecompiler.elements.RootElement;
import org.ajax4jsf.templatecompiler.elements.TemplateElement;
import org.ajax4jsf.templatecompiler.elements.vcp.FResourceTemplateElement;
import org.ajax4jsf.templatecompiler.elements.vcp.HeaderResourceElement;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResourcesConfigGenerator
extends FacesConfigGenerator {
    private File resourcesConfig;
    private File templatesDirectory;

    public ResourcesConfigGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    /*
     * Unable to fully structure code
     */
    private void addResources(ResourcesConfigGeneratorBean configBean, TemplateElement templateElement, String packageName, RendererBean renderer, BuilderConfig builderConfig) throws ClassNotFoundException {
        if (templateElement instanceof FResourceTemplateElement) {
            resourceTemplateElement = (FResourceTemplateElement)templateElement;
            name = resourceTemplateElement.getName();
            this.addResource(name, packageName, configBean);
        } else if (templateElement instanceof RootElement) {
            block25: {
                rootElement = (RootElement)templateElement;
                compilationContext = rootElement.getComponentBean();
                classname = renderer.getClassname();
                idx = classname.lastIndexOf(46);
                packageName = idx != -1 ? classname.substring(0, idx) : "";
                loader = builderConfig.getLoader();
                cl = null;
                try {
                    cl = loader.loadClass(classname);
                }
                catch (ClassNotFoundException e) {
                    superclass = compilationContext.getBaseclassPackageName() + "." + compilationContext.getBaseclassName();
                    if (superclass == null) break block25;
                    cl = loader.loadClass(superclass);
                }
            }
            if (cl != null) {
                interceptor = new GetResourceInterceptor();
                instance = AbstractClassStubBuilder.buildStub(cl, interceptor, builderConfig.getLoader());
                try {
                    method = null;
                    object = null;
                    cl1 = instance.getClass();
                    while (cl1 != null && method == null) {
                        try {
                            method = cl1.getDeclaredMethod("getStyles", null);
                        }
                        catch (NoSuchMethodException e) {
                            cl1 = cl1.getSuperclass();
                        }
                    }
                    if (method != null) {
                        method.setAccessible(true);
                        object = method.invoke(instance, null);
                        list = interceptor.getList();
                        if (list != null) {
                            for (String name : list) {
                                this.addResource(name, packageName, configBean);
                            }
                        }
                    }
                    interceptor.clearList();
                    method = null;
                    cl1 = instance.getClass();
                    while (cl1 != null && method == null) {
                        try {
                            method = cl1.getDeclaredMethod("getScripts", null);
                        }
                        catch (NoSuchMethodException e) {
                            cl1 = cl1.getSuperclass();
                        }
                    }
                    if (method == null) ** GOTO lbl80
                    method.setAccessible(true);
                    object = method.invoke(instance, null);
                    list = interceptor.getList();
                    if (list == null) ** GOTO lbl80
                    for (String name : list) {
                        this.addResource(name, packageName, configBean);
                    }
                }
                catch (SecurityException e) {
                    builderConfig.getLog().error(e.getMessage(), e);
                }
                catch (IllegalArgumentException e) {
                    builderConfig.getLog().error(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    builderConfig.getLog().error(e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    builderConfig.getLog().error(e.getMessage(), e);
                }
            }
        } else if (templateElement instanceof HeaderResourceElement && (paths = (resourceElement = (HeaderResourceElement)templateElement).getResourcePaths()) != null) {
            for (i = 0; i < paths.length; ++i) {
                string = paths[i];
                this.addResource(string, packageName, configBean);
            }
        }
lbl80:
        // 11 sources

        subElements = templateElement.getSubElements();
        for (TemplateElement element : subElements) {
            this.addResources(configBean, element, packageName, renderer, builderConfig);
        }
    }

    private void addResource(String name, String packageName, ResourcesConfigGeneratorBean configBean) {
        String resolvedPath = this.resolveResourcePath(name, packageName);
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (resolvedPath != null) {
            configBean.addPathResource(name, resolvedPath);
        } else {
            configBean.addClassResource(name, name);
        }
    }

    private String resolveResourcePath(String name, String packageName) {
        if (name.contains("/")) {
            String resolvedName;
            if (!name.startsWith("/")) {
                StringBuffer normalizedName = new StringBuffer();
                normalizedName.append(packageName.replace('.', '/'));
                if (!packageName.endsWith("/")) {
                    normalizedName.append('/');
                }
                normalizedName.append(name);
                resolvedName = normalizedName.toString();
            } else {
                resolvedName = name.length() > 0 ? name.substring(1) : null;
            }
            return resolvedName;
        }
        return null;
    }

    private void addResources(ResourcesConfigGeneratorBean configBean, RendererBean renderer, BuilderConfig builderConfig) throws CompilationException, IOException, ClassNotFoundException {
        if (null != renderer && renderer.isGenerate() && null != renderer.getTemplate()) {
            File template = null != this.getTemplates() ? new File(this.getTemplates(), renderer.getTemplate()) : new File(renderer.getTemplate());
            RendererCompilationContext rendererBean = new RendererCompilationContext(this.getLog(), this.getClassLoader(), this.getConfig());
            TemplateCompiler templateCompiler = new TemplateCompiler();
            FileInputStream templateStream = new FileInputStream(template);
            templateCompiler.processing(templateStream, rendererBean);
            TemplateElement root = rendererBean.getTree();
            String classname = renderer.getClassname();
            int idx = classname.lastIndexOf(46);
            String packageName = idx != -1 ? classname.substring(0, idx) : "";
            this.addResources(configBean, root, packageName, renderer, builderConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFiles(BuilderConfig config) throws GeneratorException {
        VelocityContext context = new VelocityContext();
        Template template = this.getTemplate();
        try {
            final ResourcesConfigGeneratorBean bean = new ResourcesConfigGeneratorBean();
            List<ComponentBean> components = config.getComponents();
            for (ComponentBean componentBean : components) {
                RendererBean rendererBean = componentBean.getRenderer();
                this.addResources(bean, rendererBean, config);
            }
            List<RendererBean> renderers = config.getRenderers();
            for (RendererBean rendererBean : renderers) {
                this.addResources(bean, rendererBean, config);
            }
            LinkedHashSet<String> pathResourcesSet = new LinkedHashSet<String>(bean.getPathResources().values());
            for (String resourcePath : pathResourcesSet) {
                if (resourcePath == null || !resourcePath.endsWith(".xcss")) continue;
                this.debug("XCSS file detected: " + resourcePath);
                InputStream resourceStream = this.getClassLoader().getResourceAsStream(resourcePath);
                if (resourceStream == null) continue;
                this.debug("XCSS file exists in classpath");
                try {
                    SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                    SAXParser parser = parserFactory.newSAXParser();
                    parser.parse(resourceStream, new DefaultHandler(){

                        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                            String value;
                            super.startElement(uri, localName, name, attributes);
                            if ("f:resource".equals(name) && (value = attributes.getValue("f:key")) != null) {
                                ResourcesConfigGenerator.this.debug("Adding resource: " + value);
                                ResourcesConfigGenerator.this.addResource(value, "", bean);
                            }
                        }
                    });
                }
                finally {
                    try {
                        resourceStream.close();
                    }
                    catch (IOException e) {
                        this.getLog().error(e.getLocalizedMessage(), e);
                    }
                }
            }
            context.put("classResources", bean.getClassResources());
            context.put("pathResources", bean.getPathResources());
            context.put("resourcesConfig", (Object)this);
            File configFile = this.getResourcesConfig();
            File javaDir = configFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            if (configFile.exists()) {
                configFile.delete();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(configFile));
            template.merge((Context)context, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (Exception e) {
            throw new GeneratorException("Error create new resources-config.xml ", e);
        }
    }

    protected String getRootTag() {
        return "resource-config";
    }

    public File getResourcesConfig() {
        return this.resourcesConfig;
    }

    public void setResourcesConfig(File resourcesConfig) {
        this.resourcesConfig = resourcesConfig;
    }

    protected String getDefaultTemplateName() {
        return "resources-config.vm";
    }

    public void setTemplates(File templatesDirectory) {
        this.templatesDirectory = templatesDirectory;
    }

    public File getTemplates() {
        return this.templatesDirectory;
    }
}

