/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.ConverterBean;
import org.ajax4jsf.builder.config.FunctionBean;
import org.ajax4jsf.builder.config.ListenerBean;
import org.ajax4jsf.builder.config.ValidatorBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.XMLConfigGenerator;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class TaglibGenerator
extends XMLConfigGenerator {
    private static final String TAGLIB_TEMPLATE_NAME = "taglib.vm";
    private File _taglib = null;
    private String _uri = null;
    private String _shortname = null;
    private String _description = null;
    private String _displayname = null;
    private String _tlibversion = "1.2";
    private String _jspversion = "2.0";
    private String _listenerclass = null;
    private String _validatorclass = null;

    public TaglibGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        ArrayList<ComponentBean> compmnents = new ArrayList<ComponentBean>();
        for (ComponentBean component : config.getComponents()) {
            boolean includeComponent = true;
            if (component.getTag() == null || component.getTag().getTaglib() != null && !component.getTag().getTaglib().equals(this.getShortname())) continue;
            includeComponent = this.isIncludeComponent(component);
            if (includeComponent) {
                this.info("Component " + component.getName() + " included in taglib " + this.getShortname());
                compmnents.add(component);
                continue;
            }
            this.info("Component " + component.getName() + " excluded from taglib " + this.getShortname());
        }
        ArrayList<ValidatorBean> validators = new ArrayList<ValidatorBean>();
        for (ValidatorBean validator : config.getValidators()) {
            boolean includeComponent = true;
            if (validator.getTag() == null || validator.getTag().getTaglib() != null && !validator.getTag().getTaglib().equals(this.getShortname())) continue;
            includeComponent = this.isIncludeComponent(validator);
            if (includeComponent) {
                this.info("Validator " + validator.getName() + " included in taglib " + this.getShortname());
                validators.add(validator);
                continue;
            }
            this.info("Validator " + validator.getName() + " excluded from taglib " + this.getShortname());
        }
        ArrayList<ConverterBean> converters = new ArrayList<ConverterBean>();
        for (ConverterBean converter : config.getConverters()) {
            boolean includeComponent = true;
            if (converter.getTag() == null || converter.getTag().getTaglib() != null && !converter.getTag().getTaglib().equals(this.getShortname())) continue;
            includeComponent = this.isIncludeComponent(converter);
            if (includeComponent) {
                this.info("Converter " + converter.getName() + " included in taglib " + this.getShortname());
                converters.add(converter);
                continue;
            }
            this.info("Converter " + converter.getName() + " excluded from taglib " + this.getShortname());
        }
        ArrayList<ListenerBean> listeners = new ArrayList<ListenerBean>();
        for (ListenerBean listener : config.getListeners()) {
            boolean includeComponent = true;
            if (listener.getTag() == null || listener.getTag().getTaglib() != null && !listener.getTag().getTaglib().equals(this.getShortname())) continue;
            includeComponent = this.isIncludeComponent(listener);
            if (includeComponent) {
                this.info("Listener " + listener.getName() + " included in taglib " + this.getShortname());
                listeners.add(listener);
                continue;
            }
            this.info("Listener " + listener.getName() + " excluded from taglib " + this.getShortname());
        }
        ArrayList<FunctionBean> functions = new ArrayList<FunctionBean>();
        for (FunctionBean functionBean : config.getFunctions()) {
            if (this.isIncludeComponent(functionBean)) {
                this.info("Function " + functionBean.getName() + " included in taglib " + this.getShortname());
                functions.add(functionBean);
                continue;
            }
            this.info("Function " + functionBean.getName() + " excluded from taglib " + this.getShortname());
        }
        if (compmnents.size() > 0 || validators.size() > 0 || converters.size() > 0 || functions.size() > 0) {
            VelocityContext context = new VelocityContext();
            Template template = this.getTemplate();
            if (compmnents.size() > 0) {
                context.put("components", compmnents);
            }
            if (validators.size() > 0) {
                context.put("validators", validators);
            }
            if (converters.size() > 0) {
                context.put("converters", converters);
            }
            if (listeners.size() > 0) {
                context.put("listeners", listeners);
            }
            if (functions.size() > 0) {
                context.put("functions", functions);
            }
            context.put("taglib", (Object)this);
            File taglibFile = this.getTaglib();
            File javaDir = taglibFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            try {
                if (taglibFile.exists()) {
                    taglibFile.delete();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(taglibFile));
                template.merge((Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error create new taglib file ", e);
            }
        } else {
            this.info("No components included in taglib " + this.getShortname());
        }
    }

    protected String getDefaultTemplateName() {
        return TAGLIB_TEMPLATE_NAME;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDisplayname() {
        return this._displayname;
    }

    public void setDisplayname(String displayName) {
        this._displayname = displayName;
    }

    public String getJspversion() {
        return this._jspversion;
    }

    public void setJspversion(String jspVersion) {
        this._jspversion = jspVersion;
    }

    public String getListenerclass() {
        return this._listenerclass;
    }

    public void setListenerclass(String listenerClass) {
        this._listenerclass = listenerClass;
    }

    public String getShortname() {
        return this._shortname;
    }

    public void setShortname(String shortName) {
        this._shortname = shortName;
    }

    public File getTaglib() {
        return this._taglib;
    }

    public void setTaglib(File taglib) {
        this._taglib = taglib;
    }

    public String getTlibversion() {
        return this._tlibversion;
    }

    public void setTlibversion(String tlibVersion) {
        this._tlibversion = tlibVersion;
    }

    public String getUri() {
        return this._uri;
    }

    public void setUri(String uri) {
        this._uri = uri;
    }

    public String getValidatorclass() {
        return this._validatorclass;
    }

    public void setValidatorclass(String validatorClass) {
        this._validatorclass = validatorClass;
    }

    protected String getRootTag() {
        return "taglib";
    }
}

