/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.builder;

import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ajax4jsf.builder.config.ClassVisitor;
import org.ajax4jsf.builder.config.ClassWalkingLogic;
import org.ajax4jsf.builder.model.JavaPrimitive;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.elements.A4JRendererElementsFactory;
import org.ajax4jsf.templatecompiler.elements.ElementsFactory;
import org.ajax4jsf.templatecompiler.elements.TemplateElement;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompilationContext
implements CompilationContext {
    private static final Log log = LogFactory.getLog(AbstractCompilationContext.class);
    private static final String VCPBODY = "VCPBODY";
    private static final String regexComponent = "(.*)VCPBODY(.*)VCPBODY(.*)";
    private static final Pattern patternComponent = Pattern.compile("(.*)VCPBODY(.*)VCPBODY(.*)", 33);
    private static final String DEFAULT_BASE_CLASS = "org.ajax4jsf.renderkit.RendererBase";
    private String packageName;
    private String className;
    private String baseClassName = "org.ajax4jsf.renderkit.RendererBase";
    private ArrayList<String> declarations;
    private ArrayList<String> imports;
    private String[] EncodeBegin;
    private String[] EncodeEnd;
    private String[] EncodeChildren;
    private Map<String, Map<String, PropertyDescriptor>> resolvedProperties = new HashMap<String, Map<String, PropertyDescriptor>>();
    private HashMap<String, Class<?>> variables = new HashMap();
    private static String[] defaultImports = new String[]{"java.util.Iterator", "java.util.Collection", "java.util.Map", "java.io.IOException", "javax.faces.component.UIComponent", "javax.faces.context.FacesContext", "javax.faces.context.ResponseWriter", "org.ajax4jsf.renderkit.ComponentsVariableResolver", "org.ajax4jsf.renderkit.ComponentVariables"};
    private TemplateElement tree;
    private List<ElementsFactory> elementFactories = new ArrayList<ElementsFactory>();
    private String componentClass;
    private ClassLoader classLoader;

    public AbstractCompilationContext() {
        this.declarations = new ArrayList();
        this.imports = new ArrayList();
        this.imports.addAll(Arrays.asList(defaultImports));
        this.elementFactories.add(new A4JRendererElementsFactory());
    }

    public AbstractCompilationContext(ClassLoader loader) throws CompilationException {
        this();
        this.classLoader = loader;
        this.setDefaultVariables();
    }

    public void addElementsFactory(ElementsFactory factory) {
        this.elementFactories.add(0, factory);
    }

    @Override
    public void setComponentClass(String componentClass) throws CompilationException {
        this.componentClass = componentClass;
        this.addVariable("component", componentClass);
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void setFullClassName(String fullClassName) {
        int dotIndex = fullClassName.lastIndexOf(".");
        String tempPackageName = "";
        String tempClassName = fullClassName;
        if (dotIndex != -1) {
            tempPackageName = fullClassName.substring(0, dotIndex);
            tempClassName = fullClassName.substring(dotIndex + 1);
        }
        this.setPackageName(tempPackageName);
        this.setClassName(tempClassName);
    }

    @Override
    public void setBaseclass(String baseclassName) throws CompilationException {
        this.baseClassName = baseclassName;
        this.addVariable("this", baseclassName);
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getBaseclassPackageName() {
        String packageName = null;
        int dotIndex = this.baseClassName.lastIndexOf(".");
        if (dotIndex != -1) {
            packageName = this.baseClassName.substring(0, dotIndex);
        }
        return packageName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getBaseclassName() {
        String className = null;
        if (this.baseClassName != null && this.baseClassName.length() != 0) {
            int dotIndex = this.baseClassName.lastIndexOf(".");
            className = dotIndex != -1 ? this.baseClassName.substring(dotIndex + 1) : this.baseClassName;
        }
        return className;
    }

    @Override
    public String getFullClassName() {
        StringBuffer buf = new StringBuffer();
        if (this.packageName != null && this.packageName.length() != 0) {
            buf.append(this.packageName);
            buf.append('.');
        }
        buf.append(this.className);
        return buf.toString();
    }

    @Override
    public String getFullBaseclass() {
        return this.baseClassName;
    }

    @Override
    public String getComponentFileName() {
        return this.getFullClassName().replace('.', '/');
    }

    @Override
    public String getComponentClass() {
        String returnStr = this.componentClass;
        return returnStr;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String[] getDeclarations() {
        return this.declarations.toArray(new String[0]);
    }

    @Override
    public String[] getImports() {
        return this.imports.toArray(new String[0]);
    }

    @Override
    public void addToImport(String className) {
        this.imports.add(className);
    }

    @Override
    public void addToDeclaration(String declaration) {
        this.declarations.add(declaration);
    }

    @Override
    public void addVariable(String variableName) throws CompilationException {
        this.addVariable(variableName, "java.lang.String");
    }

    @Override
    public void addVariable(String variableName, Class<?> clazz) {
        this.variables.put(variableName, clazz);
    }

    @Override
    public void addVariable(String variableName, String typeName) throws CompilationException {
        try {
            Class<?> clazz = this.loadClass(typeName);
            this.variables.put(variableName, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new CompilationException("Error create renderer variable " + variableName + " with type " + typeName, e);
        }
    }

    @Override
    public boolean containsVariable(String variableName) {
        return this.variables.containsKey(variableName);
    }

    @Override
    public Class<?> getVariableType(String variableName) {
        return this.variables.get(variableName);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = JavaPrimitive.isPrimitive(className) ? JavaPrimitive.forName(className) : this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            System.err.println("ClassNotFoundException message: " + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (null == clazz) {
            log.error((Object)("Error load class: " + className));
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    @Override
    public void setDefaultVariables() throws CompilationException {
        this.addVariable("component", "javax.faces.component.UIComponent");
        this.addVariable("context", "javax.faces.context.FacesContext");
        this.addVariable("writer", "javax.faces.context.ResponseWriter");
        this.addVariable("variables", "org.ajax4jsf.renderkit.ComponentVariables");
    }

    @Override
    public Class<?> getMethodReturnedClass(Class<?> clazz, String methodName, Class<?>[] parametersTypes) {
        Class<?> returnedType = null;
        log.debug((Object)("class : " + clazz.getName() + "\n\t method : " + methodName + "\n\t paramTypes : " + Arrays.asList(parametersTypes).toString()));
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, (String)methodName, (Class[])parametersTypes);
        if (null != method) {
            returnedType = method.getReturnType();
            log.debug((Object)("Method found, return type : " + returnedType.getName()));
        } else {
            log.error((Object)("Method not found: " + clazz + "#" + methodName + "(" + parametersTypes + ")"));
        }
        return returnedType;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName) {
        Map<String, PropertyDescriptor> descriptors = this.resolvedProperties.get(clazz.getName());
        if (descriptors == null) {
            descriptors = this.resolveProperties(clazz);
            this.resolvedProperties.put(clazz.getName(), descriptors);
        }
        return descriptors.get(propertyName);
    }

    private Map<String, PropertyDescriptor> resolveProperties(Class<?> clazz) {
        final HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
        new ClassWalkingLogic(clazz).walk(new ClassVisitor(){

            @Override
            public void visit(Class<?> clazz) {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor descriptor : pds = PropertyUtils.getPropertyDescriptors(clazz)) {
                    descriptors.put(descriptor.getName(), descriptor);
                }
            }
        });
        return descriptors;
    }

    @Override
    public String[] getEncodeBegin() {
        return this.EncodeBegin;
    }

    @Override
    public String[] getEncodeChild() {
        return this.EncodeChildren;
    }

    @Override
    public String[] getEncodeEnd() {
        return this.EncodeEnd;
    }

    @Override
    public void setCode(String code) {
        String strEncodeEnd;
        String strEncodeChildren;
        String strEncodeBegin;
        Matcher matcher = patternComponent.matcher(code);
        if (matcher.find()) {
            strEncodeBegin = matcher.group(1);
            strEncodeChildren = matcher.group(2);
            strEncodeEnd = matcher.group(3);
        } else {
            strEncodeBegin = "";
            strEncodeChildren = "";
            strEncodeEnd = code;
        }
        if (strEncodeBegin != null && strEncodeBegin.length() != 0) {
            this.EncodeBegin = strEncodeBegin.split(";\n");
        }
        if (strEncodeChildren != null && strEncodeChildren.length() != 0) {
            this.EncodeChildren = strEncodeChildren.split(";\n");
        }
        if (strEncodeEnd != null && strEncodeEnd.length() != 0) {
            this.EncodeEnd = strEncodeEnd.split(";\n");
        }
    }

    @Override
    public TemplateElement getTree() {
        return this.tree;
    }

    @Override
    public void setTree(TemplateElement tree) {
        this.tree = tree;
    }

    @Override
    public TemplateElement getProcessor(Node nodeElement) throws CompilationException {
        ListIterator<ElementsFactory> iter = this.elementFactories.listIterator();
        while (iter.hasNext()) {
            ElementsFactory factory = (ElementsFactory)iter.next();
            TemplateElement processor = factory.getProcessor(nodeElement, this);
            if (null == processor) continue;
            return processor;
        }
        return null;
    }

    @Override
    public String processTemplate(String name, VelocityContext context) throws CompilationException {
        StringWriter out = new StringWriter();
        try {
            this.getTemplate(name).merge((Context)context, (Writer)out);
        }
        catch (ResourceNotFoundException e) {
            throw new CompilationException(e.getLocalizedMessage());
        }
        catch (ParseErrorException e) {
            throw new CompilationException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new CompilationException(e.getLocalizedMessage());
        }
        return out.toString();
    }

    public Map<String, Map<String, PropertyDescriptor>> getResolvedProperties() {
        return this.resolvedProperties;
    }
}

