/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.builder;

public class StringUtils {
    private static final int HEX_DIFF = 7;

    public static String getEscapedString(String text) {
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (StringUtils.isalnum(c)) {
                buf.append(c);
                continue;
            }
            switch (c) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String hex(char c) {
        int lsi;
        char lsd = (char)(lsi + ((lsi = (c & 0xF) + 48) > 57 ? 7 : 0));
        int msi = (c >> 4) + 48;
        char msd = (char)(msi + (msi > 57 ? 7 : 0));
        return "%" + msd + lsd;
    }

    public static boolean isalnum(char c) {
        return StringUtils.isalpha(c) || StringUtils.isdigit(c);
    }

    public static boolean isalpha(char c) {
        return StringUtils.isupper(c) || StringUtils.islower(c);
    }

    public static boolean isupper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean islower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isdigit(char c) {
        return c >= '0' && c <= '9';
    }
}

