/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.elements.TemplateElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TemplateCompiler {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String BASECLASS_ATTRIBUTE = "baseclass";
    private static final String COMPONENT_CLASS_ATTRIBUTE = "component";
    public static final String TEMPLATES_TEMPLATECOMPILER_PATH = "META-INF/templates/templatecompiler";
    public static final String TEMPLATES_PATH = "META-INF/templates";
    private static final String TEMPLATE_FILE = "ComponentTemplate.vm";

    public void processing(InputStream input, CompilationContext componentBean) throws CompilationException {
        try {
            Document xmlDocument = this.parseXml(input);
            Element rootElement = xmlDocument.getDocumentElement();
            NamedNodeMap attributes = rootElement.getAttributes();
            if (attributes != null) {
                Node componentClass;
                Node attributeBaseclass;
                Node attributeClass = attributes.getNamedItem(CLASS_ATTRIBUTE);
                if (attributeClass != null) {
                    componentBean.setFullClassName(attributeClass.getNodeValue());
                }
                if ((attributeBaseclass = attributes.getNamedItem(BASECLASS_ATTRIBUTE)) != null) {
                    String nodeValue = attributeBaseclass.getNodeValue();
                    componentBean.setBaseclass(nodeValue);
                }
                if ((componentClass = attributes.getNamedItem(COMPONENT_CLASS_ATTRIBUTE)) != null) {
                    String nodeValue = componentClass.getNodeValue();
                    componentBean.setComponentClass(nodeValue);
                }
            }
            componentBean.setTree(this.parseElement(rootElement, componentBean));
        }
        catch (Exception e) {
            throw new CompilationException(e);
        }
    }

    protected Document parseXml(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.parse(input);
        return xmlDocument;
    }

    public void generateCode(CompilationContext componentBean, Writer out) throws CompilationException {
        try {
            out.write(componentBean.getTree().toCode());
        }
        catch (IOException e) {
            throw new CompilationException(e);
        }
    }

    private TemplateElement parseElement(Node element, CompilationContext context) throws CompilationException {
        TemplateElement templateElement = null;
        templateElement = context.getProcessor(element);
        if (templateElement == null) {
            return null;
        }
        if (!templateElement.isSkipBody()) {
            NodeList subNodes = element.getChildNodes();
            for (int iElement = 0; iElement != subNodes.getLength(); ++iElement) {
                Node subElement = subNodes.item(iElement);
                templateElement.addSubElement(this.parseElement(subElement, context));
            }
        }
        return templateElement;
    }
}

