/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements.std;

import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.el.ELParser;
import org.ajax4jsf.templatecompiler.elements.TemplateElementBase;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ObjectTemplateElement
extends TemplateElementBase {
    private static final String TEMPLATE = "META-INF/templates/templatecompiler/object.vm";
    private String strThisVariable;
    private String strExpression;
    private String strType;

    public ObjectTemplateElement(Node element, CompilationContext componentBean) {
        super(element, componentBean);
        NamedNodeMap nnm = element.getAttributes();
        String sVariableName = nnm.getNamedItem("var").getNodeValue();
        Node value = nnm.getNamedItem("value");
        Node type = nnm.getNamedItem("type");
        if (type != null) {
            this.strType = type.getNodeValue();
        }
        String strTempExpression = value != null ? value.getNodeValue() : element.getTextContent();
        this.strThisVariable = sVariableName;
        if (strTempExpression != null && strTempExpression.length() != 0) {
            this.strExpression = ELParser.compileEL(strTempExpression, componentBean);
        } else if (String.class.getName().equals(this.strType)) {
            this.strExpression = "\"\"";
        }
        if (this.strType != null) {
            try {
                this.getComponentBean().addVariable(this.strThisVariable, this.strType);
            }
            catch (CompilationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public String getBeginElement() throws CompilationException {
        VelocityContext context = new VelocityContext();
        context.put("variable", (Object)this.strThisVariable);
        context.put("expression", (Object)this.strExpression);
        context.put("type", this.strType != null ? this.strType.replace('$', '.') : null);
        return this.getComponentBean().processTemplate(this.getTemplateName(), context);
    }

    protected String getTemplateName() {
        return TEMPLATE;
    }

    public String getEndElement() {
        return null;
    }
}

