/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements.vcp;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.el.ELParser;
import org.ajax4jsf.templatecompiler.elements.TemplateElementBase;
import org.ajax4jsf.templatecompiler.elements.vcp.Parameter;
import org.ajax4jsf.templatecompiler.elements.vcp.ParameterProcessor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FCallTemplateElement
extends TemplateElementBase {
    private static final Log log = LogFactory.getLog(FCallTemplateElement.class);
    private String functionName;
    private String variable;
    private String fullFunctionName;
    private boolean useOnlyEnumeratingParaments = false;
    private static final String FUNCTION_DELIMITER = "\\.";
    private static final String VAR_ATTRIBUTE_NAME = "var";
    private static final String FUNCTION_NAME_ATTRIBUTE_NAME = "name";
    private static final String USE_ONLY_THIS_PARAMETERS = "use_only_this_parameters";
    private static final String[][] PARAM_NAMES = new String[][]{{"context"}, {"context", "component"}};
    private static final String TEMPLATE = "META-INF/templates/templatecompiler/insertCall.vm";
    private ArrayList parameters;

    public FCallTemplateElement(Node element, CompilationContext componentBean) throws CompilationException {
        super(element, componentBean);
        Node variableName;
        NamedNodeMap nnm = element.getAttributes();
        Node functionNameNode = nnm.getNamedItem(FUNCTION_NAME_ATTRIBUTE_NAME);
        if (functionNameNode == null) {
            throw new CompilationException("function name is not set");
        }
        this.functionName = functionNameNode.getNodeValue();
        Node nodeUseOnlyThisParameters = nnm.getNamedItem(USE_ONLY_THIS_PARAMETERS);
        if (nodeUseOnlyThisParameters != null) {
            this.useOnlyEnumeratingParaments = Boolean.getBoolean(nodeUseOnlyThisParameters.getNodeValue());
        }
        if ((variableName = nnm.getNamedItem(VAR_ATTRIBUTE_NAME)) != null) {
            this.variable = variableName.getNodeValue();
        }
        ParameterProcessor parameterProcessor = new ParameterProcessor(element, componentBean);
        this.parameters = parameterProcessor.getParameters();
        log.debug((Object)this.parameters);
        List<String> decodeFunctionName = null;
        decodeFunctionName = Arrays.asList(this.functionName.split(FUNCTION_DELIMITER));
        if (null == decodeFunctionName) {
            decodeFunctionName = new ArrayList<String>();
            decodeFunctionName.add(this.functionName);
        }
        ArrayList<String> functionNames = new ArrayList<String>();
        String lastClassName = componentBean.getFullBaseclass();
        Iterator<String> iter = decodeFunctionName.iterator();
        while (iter.hasNext()) {
            String elementFunction = iter.next();
            try {
                log.debug((Object)("Try to load class : " + lastClassName));
                Class<?> clazz = componentBean.loadClass(lastClassName);
                if (!iter.hasNext()) {
                    String method = this.getMethod(clazz, elementFunction);
                    if (method != null) {
                        log.debug((Object)method);
                        functionNames.add(method);
                        continue;
                    }
                    log.error((Object)("Method  " + elementFunction + " not found in class : " + lastClassName));
                    throw new CompilationException();
                }
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(clazz, elementFunction);
                if (propertyDescriptor != null) {
                    functionNames.add(propertyDescriptor.getReadMethod().getName() + "()");
                    log.debug((Object)("Property " + elementFunction + " mapped to function  : " + propertyDescriptor.getReadMethod().getName()));
                    lastClassName = propertyDescriptor.getPropertyType().getName();
                    continue;
                }
                log.error((Object)("Property " + elementFunction + " not found in class : " + lastClassName));
                throw new CompilationException();
            }
            catch (Throwable e) {
                log.error((Object)("Error load class : " + lastClassName + ", " + e.getLocalizedMessage()));
                e.printStackTrace();
                throw new CompilationException("Error load class : " + lastClassName, e);
            }
        }
        StringBuffer tmpbuf = new StringBuffer();
        for (String tmpElement : functionNames) {
            if (tmpbuf.length() != 0) {
                tmpbuf.append(".");
            }
            tmpbuf.append(tmpElement);
        }
        this.fullFunctionName = tmpbuf.toString();
    }

    private PropertyDescriptor getPropertyDescriptor(Class clazz, String propertyName) {
        PropertyDescriptor returnValue = null;
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Class)clazz);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            if (!descriptor.getName().equals(propertyName)) continue;
            returnValue = descriptor;
            break;
        }
        return returnValue;
    }

    private String getMethod(Class clazz, String methodName) throws ClassNotFoundException {
        int i;
        String returnValue = null;
        Class[][] arrayParametersTypes = null;
        if (this.useOnlyEnumeratingParaments) {
            arrayParametersTypes = new Class[1][this.parameters.size()];
            for (i = 0; i < this.parameters.size(); ++i) {
                arrayParametersTypes[0][i] = ((Parameter)this.parameters.get(i)).getType();
            }
        } else {
            arrayParametersTypes = new Class[PARAM_NAMES.length + 1][];
            for (i = 0; i < arrayParametersTypes.length; ++i) {
                int addlength = 0;
                if (i < PARAM_NAMES.length) {
                    addlength = PARAM_NAMES[i].length;
                }
                arrayParametersTypes[i] = new Class[addlength + this.parameters.size()];
            }
            for (i = 0; i < PARAM_NAMES.length; ++i) {
                for (int j = 0; j < PARAM_NAMES[i].length; ++j) {
                    arrayParametersTypes[i][j] = this.getComponentBean().getVariableType(PARAM_NAMES[i][j]);
                }
            }
            for (i = 0; i < arrayParametersTypes.length; ++i) {
                int shift = 0;
                if (i < PARAM_NAMES.length) {
                    shift = PARAM_NAMES[i].length;
                }
                for (int j = 0; j < this.parameters.size(); ++j) {
                    Parameter parameter = (Parameter)this.parameters.get(j);
                    arrayParametersTypes[i][shift + j] = parameter.getType();
                }
            }
        }
        for (i = 0; i < arrayParametersTypes.length; ++i) {
            if (null == this.getComponentBean().getMethodReturnedClass(clazz, methodName, arrayParametersTypes[i])) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(methodName);
            buffer.append("(");
            int shift = 0;
            if (i < PARAM_NAMES.length) {
                shift = PARAM_NAMES[i].length;
            }
            for (int j = 0; j < arrayParametersTypes[i].length; ++j) {
                if (j > 0) {
                    buffer.append(", ");
                }
                if (i < PARAM_NAMES.length && j < PARAM_NAMES[i].length) {
                    buffer.append(PARAM_NAMES[i][j]);
                    continue;
                }
                Parameter parameter = (Parameter)this.parameters.get(j - shift);
                String tmp = ELParser.compileEL(parameter.getValue(), this.getComponentBean());
                buffer.append(tmp);
            }
            buffer.append(")");
            returnValue = buffer.toString();
            break;
        }
        return returnValue;
    }

    public String getBeginElement() throws CompilationException {
        VelocityContext context = new VelocityContext();
        context.put("variableName", (Object)this.variable);
        context.put("function", (Object)this.fullFunctionName);
        return this.getComponentBean().processTemplate(this.getTemplateName(), context);
    }

    protected String getTemplateName() {
        return TEMPLATE;
    }

    public String getEndElement() {
        return null;
    }
}

