/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements.vcp;

import java.util.ArrayList;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.elements.vcp.Parameter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterProcessor {
    private static final String PARAMETER_NODE_NAME = "f:parameter";
    private static final String PARAMETER_NODE_VALUE = "value";
    private static final String PARAMETER_NODE_TYPE = "type";
    private ArrayList arrayParameters = new ArrayList();

    public ParameterProcessor(Node element, CompilationContext componentBean) throws CompilationException {
        NodeList childNodes = element.getChildNodes();
        if (childNodes != null) {
            for (int iElement = 0; iElement < childNodes.getLength(); ++iElement) {
                Node childNode = childNodes.item(iElement);
                if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(PARAMETER_NODE_NAME)) continue;
                element.removeChild(childNode);
                --iElement;
                NamedNodeMap attributes = childNode.getAttributes();
                if (attributes == null) continue;
                Node nodeValue = attributes.getNamedItem(PARAMETER_NODE_VALUE);
                Node nodeType = attributes.getNamedItem(PARAMETER_NODE_TYPE);
                if (nodeValue == null) continue;
                Parameter param = null;
                if (null != nodeType) {
                    Class<?> parameterType;
                    try {
                        parameterType = componentBean.loadClass(nodeType.getNodeValue());
                    }
                    catch (ClassNotFoundException e) {
                        throw new CompilationException();
                    }
                    param = new Parameter(nodeValue.getNodeValue(), parameterType);
                } else {
                    param = new Parameter(nodeValue.getNodeValue());
                }
                this.arrayParameters.add(param);
            }
        }
    }

    public ArrayList getParameters() {
        return this.arrayParameters;
    }
}

