/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashSet;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class BlankRendererGenerator
extends InnerGenerator {
    private static final String RENDERER_TEMPLATE_NAME = "renderer.vm";
    private String _package = null;

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String package1) {
        this._package = package1;
    }

    public BlankRendererGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        VelocityContext context = new VelocityContext();
        Template template = this.getTemplate();
        for (ComponentBean component : config.getComponents()) {
            if (null == component.getRenderer() || !component.getRenderer().isGenerate()) continue;
            context.put("component", (Object)component);
            context.put("renderer", (Object)component.getRenderer());
            if (null == this.getPackage()) {
                context.put("package", (Object)component.getRenderer().getPackageName());
            } else {
                context.put("package", (Object)this.getPackage());
            }
            HashSet<String> importClasses = new HashSet<String>();
            importClasses.add(component.getClassname());
            importClasses.add(component.getRenderer().getSuperclass());
            context.put("imports", importClasses);
            String resultPath = null == this.getPackage() ? component.getRenderer().getClassname().replace('.', '/') + ".java" : this.getPackage().replace('.', '/') + "/" + component.getRenderer().getSimpleClassName() + ".java";
            File javaFile = new File(this.getDestDir(), resultPath);
            File javaDir = javaFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            try {
                if (javaFile.exists()) {
                    if (!component.getRenderer().isOverride()) continue;
                    javaFile.delete();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(javaFile));
                template.merge((Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error create new Renderer Java file ", e);
            }
        }
    }

    protected String getDefaultTemplateName() {
        return RENDERER_TEMPLATE_NAME;
    }
}

