/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPatternSet {
    private static final char CLASS_SEPARATOR = '.';
    private List<PatternEntry> _includes = new ArrayList<PatternEntry>();
    private List<PatternEntry> _excludes = new ArrayList<PatternEntry>();

    public PatternEntry createExclude() {
        PatternEntry entry = new PatternEntry();
        this._excludes.add(entry);
        return entry;
    }

    public PatternEntry createInclude() {
        PatternEntry entry = new PatternEntry();
        this._includes.add(entry);
        return entry;
    }

    public String[] getExcludePatterns() {
        String[] excludesPatterns = new String[this._excludes.size()];
        int i = 0;
        for (PatternEntry entry : this._excludes) {
            excludesPatterns[i++] = entry.getName();
        }
        return excludesPatterns;
    }

    public void setExcludes(String excludes) {
        this.addPatterns(this._excludes, excludes);
    }

    private void addPatterns(List<PatternEntry> list, String patterns) {
        String[] strings = patterns.split(",");
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            PatternEntry entry = new PatternEntry();
            entry.setName(string);
            list.add(entry);
        }
    }

    public void setIncludes(String includes) {
        this.addPatterns(this._includes, includes);
    }

    public String[] getIncludePatterns() {
        String[] includesPatterns = new String[this._includes.size()];
        int i = 0;
        for (PatternEntry entry : this._includes) {
            includesPatterns[i++] = entry.getName();
        }
        return includesPatterns;
    }

    public boolean matchClass(String className) {
        boolean included = true;
        if (this._includes.size() > 0) {
            included = this.matchClass(this._includes, className);
        }
        if (this._excludes.size() > 0 && included) {
            included = !this.matchClass(this._excludes, className);
        }
        return included;
    }

    private boolean matchClass(List<PatternEntry> list, String className) {
        for (PatternEntry entry : list) {
            if (!this.matchPath(entry.getName(), className)) continue;
            return true;
        }
        return false;
    }

    boolean matchPath(String pattern, String str) {
        String patDir;
        int strIdxStart;
        if (str.charAt(0) == '.' != (pattern.charAt(0) == '.')) {
            return false;
        }
        String[] patDirs = this.tokenizePathAsArray(pattern);
        String[] strDirs = this.tokenizePathAsArray(str);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxStart]).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (this.match(patDir, strDirs[strIdxStart])) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patDirs[i].equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            patDirs = null;
            strDirs = null;
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxEnd]).equals("**")) {
            if (!this.match(patDir, strDirs[strIdxEnd])) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patDirs[i].equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (!patDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = patDirs[patIdxStart + j + 1];
                    String subStr = strDirs[strIdxStart + i + j];
                    if (!this.match(subPat, subStr)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patDirs[i].equals("**")) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        return true;
    }

    boolean match(String pattern, String str) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || ch2 == strArr[i]) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && ch != strArr[strIdxStart + i3 + j]) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    String[] tokenizePathAsArray(String path) {
        int start = 0;
        int len = path.length();
        int count = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != '.') continue;
            if (pos != start) {
                ++count;
            }
            start = pos + 1;
        }
        if (len != start) {
            ++count;
        }
        String[] l = new String[count];
        count = 0;
        start = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != '.') continue;
            if (pos != start) {
                String tok = path.substring(start, pos);
                l[count++] = tok;
            }
            start = pos + 1;
        }
        if (len != start) {
            String tok;
            l[count] = tok = path.substring(start);
        }
        return l;
    }

    public class PatternEntry {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            int hashCode = 0;
            if (null != this.name) {
                hashCode = this.name.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PatternEntry) {
                PatternEntry entry = (PatternEntry)obj;
                if (null != this.name) {
                    return this.name.equals(entry.getName());
                }
                return entry.getName() == null;
            }
            return false;
        }
    }
}

