/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.ajax4jsf.builder.component.ComponentModelBuilder;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.model.JavaClass;
import org.ajax4jsf.builder.render.JavaClassRenderer;

public class ComponentGenerator2
extends InnerGenerator {
    private ComponentModelBuilder componentModelBuilder = new ComponentModelBuilder();
    private JavaClassRenderer classRenderer = new JavaClassRenderer();

    public ComponentGenerator2(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        List<ComponentBean> components = config.getComponents();
        for (ComponentBean componentBean : components) {
            if (!componentBean.isGenerate()) continue;
            JavaClass componentClass = this.componentModelBuilder.build(componentBean, this.getConfig());
            String resultPath = componentBean.getClassname().replace('.', '/') + ".java";
            File javaFile = new File(this.getDestDir(), resultPath);
            File javaDir = javaFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            try {
                if (javaFile.exists()) {
                    javaFile.delete();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(javaFile));
                PrintWriter printWriter = new PrintWriter(out);
                this.classRenderer.render(componentClass, printWriter);
                printWriter.flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error create new Component Java file ", e);
            }
        }
    }

    protected String getDefaultTemplateName() {
        return null;
    }
}

