/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashSet;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.config.TagBean;
import org.ajax4jsf.builder.config.ValidatorBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ValidatorTagGenerator
extends InnerGenerator {
    private static final String TAG_TEMPLATE_NAME = "validatorTag.vm";
    private String _package = null;

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String package1) {
        this._package = package1;
    }

    public ValidatorTagGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        VelocityContext context = new VelocityContext();
        context.put("generator", (Object)this);
        Template template = this.getTemplate();
        for (ValidatorBean validator : config.getValidators()) {
            TagBean tag = validator.getTag();
            if (null == tag || null == tag.getClassname() || !tag.isGenerate()) continue;
            this.info("Create tag class file " + validator.getClassname());
            context.put("validator", (Object)validator);
            context.put("tag", (Object)validator.getTag());
            context.put("package", (Object)validator.getTag().getPackageName());
            HashSet<String> importClasses = new HashSet<String>();
            for (PropertyBean property : validator.getProperties()) {
                if (property.isSimpleType() || property.isHidden()) continue;
                importClasses.add(property.getClassname());
            }
            importClasses.add(validator.getTag().getSuperclass());
            context.put("imports", importClasses);
            String resultPath = validator.getTag().getClassname().replace('.', '/') + ".java";
            File javaFile = new File(this.getDestDir(), resultPath);
            File javaDir = javaFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            try {
                if (javaFile.exists()) {
                    javaFile.delete();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(javaFile));
                template.merge((Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating JSP Tag Java file for validator " + validator.getName(), e);
            }
        }
    }

    protected String getDefaultTemplateName() {
        return TAG_TEMPLATE_NAME;
    }
}

