/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.ajax4jsf.builder.config.ParsingException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.xml.XMLBody;

public abstract class XMLConfigGenerator
extends InnerGenerator {
    private File _include = null;

    public XMLConfigGenerator(JSFGeneratorConfiguration config, Logger log) {
        super(config, log);
    }

    public File getInclude() {
        return this._include;
    }

    public void setInclude(File include) {
        this._include = include;
    }

    public String getIncludeContent() {
        String content = "";
        File include = this.getInclude();
        if (null != include) {
            if (include.isDirectory()) {
                File[] files = include.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.isFile()) continue;
                    content = content + this.getXMLBody(file);
                }
            } else if (include.exists()) {
                content = this.getXMLBody(include);
            }
        }
        return content;
    }

    private String getXMLBody(File file) {
        XMLBody body = new XMLBody();
        try {
            body.loadXML(new FileInputStream(file));
            if (body.isRootName(this.getRootTag())) {
                return body.getContent();
            }
        }
        catch (FileNotFoundException e) {
            this.getLog().warn("Not found include file ", e);
        }
        catch (ParsingException e) {
            this.getLog().warn("Error parsing include file ", e);
        }
        return "";
    }

    protected abstract String getRootTag();
}

