/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.render;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.ajax4jsf.builder.model.Argument;
import org.ajax4jsf.builder.model.JavaMethod;
import org.ajax4jsf.builder.model.MethodBody;
import org.ajax4jsf.builder.render.JavaLanguageElementRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethodRenderer
extends JavaLanguageElementRenderer<JavaMethod> {
    @Override
    public void render(JavaMethod javaMethod, PrintWriter out) {
        this.renderComments(javaMethod, out);
        this.renderAnnotations(javaMethod, out);
        this.renderModifiers(javaMethod, out);
        Class<?> returnType = javaMethod.getReturnType();
        if (returnType != null) {
            out.print(returnType.getSimpleName() + " ");
        }
        out.print(javaMethod.getName());
        out.print("(");
        List<Argument> arguments = javaMethod.getArguments();
        if (arguments != null) {
            Iterator<Argument> iterator = arguments.iterator();
            while (iterator.hasNext()) {
                Argument argument = iterator.next();
                out.print(argument.getType().getSimpleName());
                out.print(" ");
                out.print(argument.getName());
                if (!iterator.hasNext()) continue;
                out.print(", ");
            }
        }
        out.print(")");
        List<Class<Throwable>> exceptions = javaMethod.getExceptions();
        if (exceptions != null && !exceptions.isEmpty()) {
            out.print(" throws ");
            Iterator<Class<Throwable>> iterator = exceptions.iterator();
            while (iterator.hasNext()) {
                Class<Throwable> class1 = iterator.next();
                out.print(class1.getSimpleName());
                if (!iterator.hasNext()) continue;
                out.print(", ");
            }
        }
        out.println("{");
        MethodBody methodBody = javaMethod.getMethodBody();
        if (methodBody != null) {
            out.println(methodBody.toCode());
        }
        out.println("}");
    }
}

