/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ajax4jsf.builder.config.ParsingException;
import org.ajax4jsf.builder.xml.ArrayNodeList;
import org.ajax4jsf.builder.xml.XMLBodySerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBody {
    private Document xmlDocument;
    private Element rootElement;

    public void loadXML(InputStream input) throws ParsingException {
        this.loadXML(input, false);
    }

    public void loadXML(InputStream input, boolean namespaceAware) throws ParsingException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setIgnoringElementContentWhitespace(true);
            docFactory.setValidating(false);
            docFactory.setNamespaceAware(namespaceAware);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            this.xmlDocument = docBuilder.parse(input);
            this.rootElement = this.xmlDocument.getDocumentElement();
        }
        catch (Exception e) {
            throw new ParsingException("Error load XML ", e);
        }
    }

    public boolean isRootName(String name) {
        return this.rootElement.getNodeName().equals(name);
    }

    public String getDoctype() {
        DocumentType doctype = this.xmlDocument.getDoctype();
        if (null != doctype) {
            return doctype.getName();
        }
        return null;
    }

    public String getPiblicId() {
        DocumentType doctype = this.xmlDocument.getDoctype();
        if (null != doctype) {
            return doctype.getPublicId();
        }
        return null;
    }

    public String getRootTypeName() {
        return this.rootElement.getSchemaTypeInfo().getTypeName();
    }

    public String getContent() throws ParsingException {
        NodeList childNodes = this.rootElement.getChildNodes();
        return this.serializeNodes(childNodes);
    }

    private String serializeNodes(NodeList childNodes) throws ParsingException {
        try {
            return new XMLBodySerializer().serialize(childNodes, this.xmlDocument);
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
    }

    public String getContent(String xpath) throws ParsingException {
        return this.serializeNodes(this.getByXpath(xpath));
    }

    public NodeList getByXpath(String xpath) throws ParsingException {
        NodeList childNodes;
        XPath path = XPathFactory.newInstance().newXPath();
        try {
            childNodes = (NodeList)path.evaluate(xpath, this.xmlDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ParsingException("Error evaluate xpath", e);
        }
        return childNodes;
    }

    public NodeList getByXpathUnique(String xpath, String keyXPath, Set<String> keySet) throws ParsingException {
        if (keyXPath == null) {
            return this.getByXpath(xpath);
        }
        XPath path = XPathFactory.newInstance().newXPath();
        try {
            NodeList childNodes = this.getByXpath(xpath);
            ArrayList<Node> nodeSet = new ArrayList<Node>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i).cloneNode(true);
                String key = this.serializeNodes((NodeList)path.evaluate(keyXPath, node, XPathConstants.NODESET));
                if (keySet.contains(key)) continue;
                keySet.add(key);
                nodeSet.add(node);
            }
            return new ArrayNodeList(nodeSet.toArray(new Node[nodeSet.size()]));
        }
        catch (XPathExpressionException e) {
            throw new ParsingException("Error evaluate xpath", e);
        }
    }

    public String getContentUnique(String xpath, String keyXPath, Set<String> keySet) throws ParsingException {
        return this.serializeNodes(this.getByXpathUnique(xpath, keyXPath, keySet));
    }
}

