/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.xml;

import java.util.Comparator;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathComparator
implements Comparator<Node> {
    private XPathCompatorCriterion[] criteria;

    public XPathComparator(String ... criteria) {
        this.criteria = new XPathCompatorCriterion[criteria.length];
        for (int i = 0; i < criteria.length; ++i) {
            this.criteria[i] = new XPathCompatorCriterion(criteria[i]);
        }
    }

    @Override
    public int compare(Node o1, Node o2) {
        int result = 0;
        for (int i = 0; i < this.criteria.length && result == 0; ++i) {
            String s1 = null;
            String s2 = null;
            try {
                s1 = this.criteria[i].getValue(o1);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            try {
                s2 = this.criteria[i].getValue(o2);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            if (s1 != null) {
                if (s2 != null) {
                    result = s1.compareTo(s2);
                    continue;
                }
                result = 1;
                continue;
            }
            if (s2 == null) continue;
            result = -1;
        }
        return result;
    }

    class XPathCompatorCriterion {
        private XPathExpression expression = null;

        public XPathCompatorCriterion(String xPath) {
            try {
                this.expression = XPathFactory.newInstance().newXPath().compile(xPath);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }

        public String getValue(Object node) throws XPathExpressionException {
            return this.expression == null ? null : this.expression.evaluate(node);
        }
    }
}

