/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.el;

import java.util.Formatter;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.StringUtils;
import org.ajax4jsf.templatecompiler.el.ELCompiler;
import org.ajax4jsf.templatecompiler.el.IELCompiler;

public class ELParser {
    private static final String SIMPLE_EXPRESSION = "\"%s\"";
    private static ELParser elParser;
    private IELCompiler elCompiler = new ELCompiler();

    private ELParser() {
    }

    private static ELParser getInstance() {
        if (elParser == null) {
            elParser = new ELParser();
        }
        return elParser;
    }

    public static String compileEL(String expression, CompilationContext componentBean) {
        return ELParser.getInstance().getCompiledEL(expression, componentBean);
    }

    public String getCompiledEL(String expression, CompilationContext componentBean) {
        String returnValue;
        if (ELParser.isVBExpression(expression)) {
            returnValue = this.elCompiler.compileEL(expression, componentBean);
        } else {
            Object[] parameters = new Object[]{StringUtils.getEscapedString(expression)};
            returnValue = new Formatter().format(SIMPLE_EXPRESSION, parameters).toString();
        }
        return returnValue;
    }

    public static boolean isVBExpression(String expression) {
        if (null == expression) {
            return false;
        }
        int start = 0;
        start = expression.indexOf("#{");
        return start != -1 && start < expression.indexOf(125);
    }
}

