/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements.std;

import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.el.ELParser;
import org.ajax4jsf.templatecompiler.elements.TemplateElementBase;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ForEachTemplateElement
extends TemplateElementBase {
    private static int indexForCollection = 0;
    private static final String ATTRIBUTE_FROM = "begin";
    private static final String ATTRIBUTE_TO = "end";
    private String strItems;
    private String strFrom;
    private String strTo;
    private String strThisVariable;

    public ForEachTemplateElement(Node element, CompilationContext componentBean) {
        super(element, componentBean);
        NamedNodeMap nnm = element.getAttributes();
        Node varItem = nnm.getNamedItem("var");
        this.strThisVariable = varItem.getNodeValue();
        Node items = nnm.getNamedItem("items");
        if (items != null) {
            this.strItems = ELParser.compileEL(items.getNodeValue(), componentBean);
        } else {
            Node fromItem = nnm.getNamedItem(ATTRIBUTE_FROM);
            Node toItem = nnm.getNamedItem(ATTRIBUTE_TO);
            this.strFrom = ELParser.compileEL(fromItem.getNodeValue(), componentBean);
            this.strTo = ELParser.compileEL(toItem.getNodeValue(), componentBean);
        }
    }

    public String getBeginElement() throws CompilationException {
        String templateName;
        VelocityContext context = new VelocityContext();
        if (this.strItems != null) {
            templateName = this.getTemplate1Name();
            context.put("items", (Object)this.strItems);
            context.put("index", (Object)new Integer(++indexForCollection));
        } else {
            templateName = this.getTemplate2Name();
            context.put("from", (Object)this.strFrom);
            context.put("to", (Object)this.strTo);
        }
        context.put("item", (Object)this.strThisVariable);
        return this.getComponentBean().processTemplate(templateName, context);
    }

    protected String getTemplate2Name() {
        return "META-INF/templates/templatecompiler/FORElement_1.vm";
    }

    protected String getTemplate1Name() {
        return "META-INF/templates/templatecompiler/FORElement_2.vm";
    }

    public String getEndElement() {
        return "}";
    }
}

