/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.richfaces.cdk.generate.freemarker;

import org.richfaces.cdk.model.EventModel;

import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

/**
 * @author akolonitsky
 * @since Feb 23, 2010
 */
public class EventTemplateModel  extends BeanModel implements TemplateModel{

    static final ModelFactory FACTORY = new ModelFactory() {
        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new EventTemplateModel((EventModel) object, (BeansWrapper) wrapper);
        }
    };
    /**
     * <p class="changed_added_4_0">
     * </p>
     *
     * @param object
     * @param wrapper
     */
    public EventTemplateModel(EventModel object, BeansWrapper wrapper) {
        super(object, wrapper);
    }

    @Override              
    public TemplateModel get(String key) throws TemplateModelException {

        return super.get(key);
    }




}
