package org.richfaces.cdk.model;


import org.richfaces.cdk.util.ComparatorUtils;

import com.google.common.base.Predicate;


/**
 * <p class="changed_added_4_0">This Interface describes all JSF objects that can be generated by cdk:</p>
 * <ul>
 * <li>{@link UIComponent}</li>
 * <li>{@link Renderer}</li>
 * <li>{@link Converter}</li>
 * <li>{@link Validator}</li>
 * <li>{@link ClientBehavior}</li>
 * <li>{@link javax.faces.render.ClientBehaviorRenderer}
 * </ul>
 * @author asmirnov@exadel.com
 *
 */
public interface FacesComponent {

    /**
     * <p class="changed_added_4_0">This predicate can be used to lookup component in {@link ModelCollection} by id.</p>
     * @author asmirnov@exadel.com
     *
     */
    public static final class ComponentPredicate implements Predicate<FacesComponent> {
        
        private final FacesId id;

        /**
         * <p class="changed_added_4_0"></p>
         * @param id
         */
        public ComponentPredicate(FacesId id) {
            this.id = id;
        }

        /**
         * <p class="changed_added_4_0"></p>
         * @param name
         */
        public ComponentPredicate(String name) {
            this.id = FacesId.parseId(name);
        }
    
        @Override
        public boolean apply(FacesComponent input) {
            return ComparatorUtils.nullSafeEquals(input.getId(), this.id);
        }
    }
    /**
     * <p class="changed_added_4_0"></p>
     * @return
     */
    public FacesId getId();

    /**
     * <p class="changed_added_4_0"></p>
     * @param id
     */
    public void setId(FacesId id);

    /**
     * <p class="changed_added_4_0"></p>
     * @param targetClass the targetClass to set
     */
    public void setTargetClass(ClassName targetClass);

    /**
     * <p class="changed_added_4_0"></p>
     * @return the targetClass
     */
    public ClassName getTargetClass();

    /**
     * <p class="changed_added_4_0"></p>
     * @return the baseClass
     */
    public ClassName getBaseClass();

    /**
     * <p class="changed_added_4_0"></p>
     * @param baseClass
     */
    public abstract void setBaseClass(ClassName baseClass);

    /**
     * <p class="changed_added_4_0"></p>
     * @return
     */
    public boolean isGenerate();
    
    /**
     * <p class="changed_added_4_0"></p>
     * @param generate
     */
    public void setGenerate(boolean generate);

}