/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import org.richfaces.cdk.OutputFileManager;

public class OutputFileManagerImpl
implements OutputFileManager {
    private final Iterable<File> folders;
    private final File folder;

    public OutputFileManagerImpl(File folder) {
        this.folder = folder;
        this.folders = Collections.singleton(folder);
    }

    @Override
    public Writer createOutput(String path, long lastModified) throws IOException {
        File outputFile;
        if (null == path) {
            throw new NullPointerException("Output file path is null");
        }
        if (null == this.folder) {
            throw new FileNotFoundException("No output folder set for file " + path);
        }
        if (this.folder.exists() && !this.folder.isDirectory()) {
            throw new IOException("Output folder " + this.folder + " not is directory.");
        }
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        if ((outputFile = new File(this.folder, path)).exists()) {
            if (lastModified > 0L && outputFile.lastModified() > lastModified) {
                return null;
            }
            outputFile.delete();
        }
        outputFile.getParentFile().mkdirs();
        outputFile.createNewFile();
        return new FileWriter(outputFile);
    }

    @Override
    public File getFile(String path) throws FileNotFoundException {
        File file = new File(this.folder, path);
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(path);
    }

    @Override
    public Iterable<File> getFiles() {
        return Collections.emptySet();
    }

    @Override
    public Iterable<File> getFolders() {
        return this.folders;
    }
}

