/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.inject.Inject;
import java.util.Set;
import javax.tools.JavaCompiler;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkWriter;
import org.richfaces.cdk.LibraryBuilder;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.apt.AptException;
import org.richfaces.cdk.apt.CompilationTaskFactory;
import org.richfaces.cdk.model.ComponentLibrary;

public class AptBuilder
implements LibraryBuilder {
    @Inject
    private Logger log;
    @Inject
    private CompilationTaskFactory taskFactory;
    @Inject
    private Set<CdkWriter> generators;

    @Override
    public void build() throws CdkException {
        JavaCompiler.CompilationTask task = this.taskFactory.get();
        if (!task.call().booleanValue()) {
            throw new AptException("Compilation error");
        }
    }

    @Override
    public void generate(ComponentLibrary library) throws CdkException {
        if (0 == this.log.getErrorCount()) {
            for (CdkWriter generator : this.generators) {
                generator.render(library);
            }
        }
    }
}

