/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.apt.DummyPropertyImpl;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.util.PropertyUtils;

public class AptSourceUtils
implements SourceUtils {
    private static final String IS = "is";
    private static final int IS_LENGTH = "is".length();
    private static final String GET = "get";
    private static final String SET = "set";
    private static final int SET_LENGTH = "set".length();
    private static final int GET_LENGTH = "get".length();
    private static final ImmutableSet<String> HIDDEN_PROPERTIES = ImmutableSet.of((Object)"eventNames", (Object)"defaultEventName", (Object)"clientBehaviors", (Object)"family", (Object)"class");
    private final ProcessingEnvironment processingEnv;
    @Inject
    private Logger log;

    public AptSourceUtils(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public Set<SourceUtils.BeanProperty> getBeanPropertiesAnnotatedWith(Class<? extends Annotation> annotation, TypeElement type) {
        HashSet<SourceUtils.BeanProperty> properties = new HashSet<SourceUtils.BeanProperty>();
        Map<String, AptBeanProperty> beanProperties = this.getBeanProperties(type);
        for (AptBeanProperty beanProperty : beanProperties.values()) {
            if (!beanProperty.isAnnotationPresent(annotation)) continue;
            properties.add(beanProperty);
        }
        return properties;
    }

    @Override
    public Set<SourceUtils.BeanProperty> getAbstractBeanProperties(TypeElement type) {
        HashSet<SourceUtils.BeanProperty> properties = new HashSet<SourceUtils.BeanProperty>();
        Map<String, AptBeanProperty> beanProperties = this.getBeanProperties(type);
        for (AptBeanProperty beanProperty : beanProperties.values()) {
            if (beanProperty.isExists()) continue;
            properties.add(beanProperty);
        }
        return properties;
    }

    @Override
    public SourceUtils.BeanProperty getBeanProperty(ClassName type, String name) {
        return this.getBeanProperty(this.asTypeElement(type), name);
    }

    @Override
    public SourceUtils.BeanProperty getBeanProperty(TypeElement type, String name) {
        Map<String, AptBeanProperty> beanProperties = this.getBeanProperties(type);
        if (beanProperties.containsKey(name)) {
            return beanProperties.get(name);
        }
        return new DummyPropertyImpl(name);
    }

    Map<String, AptBeanProperty> getBeanProperties(TypeElement type) {
        HashMap result = Maps.newHashMap();
        if (null != type) {
            List<? extends Element> members = this.processingEnv.getElementUtils().getAllMembers(type);
            for (Element element : members) {
                if (!ElementKind.METHOD.equals((Object)element.getKind())) continue;
                ExecutableElement method = (ExecutableElement)element;
                this.processMethod(type, result, method);
            }
        }
        return result;
    }

    private void processMethod(TypeElement type, Map<String, AptBeanProperty> result, ExecutableElement method) {
        if (this.isPublicNonStatic(method)) {
            if (this.isGetter(method)) {
                this.processBeanPropertyAccessor(type, result, method, false);
            } else if (this.isSetter(method)) {
                this.processBeanPropertyAccessor(type, result, method, true);
            }
        }
    }

    private void processBeanPropertyAccessor(TypeElement type, Map<String, AptBeanProperty> result, ExecutableElement method, boolean setter) {
        String propertyName = this.getPropertyName(method);
        if (!HIDDEN_PROPERTIES.contains((Object)propertyName)) {
            ClassName propertyType = this.asClassDescription(setter ? method.getParameters().get(0).asType() : method.getReturnType());
            if (result.containsKey(propertyName)) {
                AptBeanProperty beanProperty = result.get(propertyName);
                this.checkPropertyType(type, propertyName, propertyType, beanProperty);
                if (null != (setter ? beanProperty.setter : beanProperty.getter)) {
                    this.log.debug((CharSequence)("Two " + (setter ? "setter" : "getter") + " methods for the same bean property " + propertyName + " in the class " + type.getQualifiedName()));
                    if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        beanProperty.setAccessMethod(method, setter);
                    }
                } else {
                    beanProperty.setAccessMethod(method, setter);
                }
            } else {
                AptBeanProperty beanProperty = new AptBeanProperty(propertyName);
                beanProperty.setAccessMethod(method, setter);
                beanProperty.type = propertyType;
                result.put(propertyName, beanProperty);
            }
        }
    }

    private String getPropertyName(ExecutableElement method) {
        return PropertyUtils.methodToName(method.getSimpleName().toString());
    }

    private void checkPropertyType(TypeElement type, String propertyName, ClassName propertyType, AptBeanProperty beanProperty) {
        if (!propertyType.equals(beanProperty.type)) {
            this.log.warn((CharSequence)("Unambiguious type for bean property " + propertyName + " in the class " + type.getQualifiedName()));
        }
    }

    private boolean isAbstract(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private boolean isPublicNonStatic(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        return modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC);
    }

    private boolean isGetter(ExecutableElement e) {
        String methodName = e.getSimpleName().toString();
        return (this.isGetterName(methodName) || this.isBooleanGetterName(methodName)) && 0 == e.getParameters().size();
    }

    private boolean isGetterName(String methodName) {
        return methodName.startsWith(GET) && methodName.length() > GET_LENGTH && Character.isUpperCase(methodName.charAt(GET_LENGTH));
    }

    private boolean isBooleanGetterName(String methodName) {
        return methodName.startsWith(IS) && methodName.length() > IS_LENGTH && Character.isUpperCase(methodName.charAt(IS_LENGTH));
    }

    private boolean isSetter(ExecutableElement e) {
        String methodName = e.getSimpleName().toString();
        return this.isSetterName(methodName) && 1 == e.getParameters().size() && !e.isVarArgs() && TypeKind.VOID.equals((Object)e.getReturnType().getKind());
    }

    private boolean isSetterName(String methodName) {
        return methodName.startsWith(SET) && methodName.length() > SET_LENGTH && Character.isUpperCase(methodName.charAt(SET_LENGTH));
    }

    private ClassName asClassDescription(TypeMirror type) {
        return new ClassName(((Object)type).toString());
    }

    @Override
    public String getDocComment(Element componentElement) {
        return this.processingEnv.getElementUtils().getDocComment(componentElement);
    }

    @Override
    public AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationType) {
        List<? extends AnnotationMirror> annotationMirrors = this.processingEnv.getElementUtils().getAllAnnotationMirrors(element);
        TypeMirror annotationTypeMirror = this.processingEnv.getElementUtils().getTypeElement(annotationType.getName()).asType();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!this.processingEnv.getTypeUtils().isSameType(annotationTypeMirror, annotationMirror.getAnnotationType())) continue;
            return annotationMirror;
        }
        return null;
    }

    @Override
    public boolean isAnnotationPresent(Element element, Class<? extends Annotation> annotationType) {
        return null != element.getAnnotation(annotationType);
    }

    @Override
    public boolean isAnnotationPropertyPresent(AnnotationMirror annotation, String propertyName) {
        return Iterables.any(this.getAnnotationValuesMap(annotation).entrySet(), (Predicate)new AnnotationAttributePredicate(propertyName));
    }

    @Override
    public boolean isDefaultValue(AnnotationMirror annotation, String propertyName) {
        Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attributeEntry = this.findAnnotationProperty(annotation, propertyName);
        return !annotation.getElementValues().containsKey(attributeEntry.getKey());
    }

    @Override
    public <T> T getAnnotationValue(AnnotationMirror annotation, String propertyName, Class<T> expectedType) {
        Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attributeEntry = this.findAnnotationProperty(annotation, propertyName);
        AnnotationValue annotationValue = attributeEntry.getValue();
        return this.convertAnnotationValue(expectedType, annotationValue);
    }

    private <T> T convertAnnotationValue(Class<T> expectedType, AnnotationValue annotationValue) {
        if (Enum.class.isAssignableFrom(expectedType)) {
            VariableElement variable = (VariableElement)annotationValue.getValue();
            return Enum.valueOf(expectedType, variable.getSimpleName().toString());
        }
        if (ClassName.class.equals(expectedType)) {
            Object value = annotationValue.getValue();
            return (T)ClassName.get(value.toString());
        }
        if (FacesId.class.equals(expectedType)) {
            String value = (String)annotationValue.getValue();
            return (T)FacesId.parseId(value);
        }
        if (AnnotationMirror.class.isAssignableFrom(expectedType)) {
            AnnotationMirror value = (AnnotationMirror)annotationValue.getValue();
            return (T)value;
        }
        return (T)annotationValue.getValue();
    }

    @Override
    public <T> Iterable<T> getAnnotationValues(AnnotationMirror annotation, String propertyName, Class<T> expectedType) {
        Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attributeEntry = this.findAnnotationProperty(annotation, propertyName);
        List annotationValues = (List)attributeEntry.getValue().getValue();
        ArrayList values = Lists.newArrayList();
        for (AnnotationValue annotationValue : annotationValues) {
            values.add(this.convertAnnotationValue(expectedType, annotationValue));
        }
        return values;
    }

    private Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> findAnnotationProperty(AnnotationMirror annotation, String propertyName) {
        try {
            return (Map.Entry)Iterables.find(this.getAnnotationValuesMap(annotation).entrySet(), (Predicate)new AnnotationAttributePredicate(propertyName));
        }
        catch (NoSuchElementException e) {
            throw new CdkException("Attribute " + propertyName + " not found for annotation " + annotation.getAnnotationType().toString());
        }
    }

    private Map<? extends ExecutableElement, ? extends AnnotationValue> getAnnotationValuesMap(AnnotationMirror annotation) {
        return this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotation);
    }

    @Override
    public void setModelProperty(Object model, AnnotationMirror annotation, String modelProperty) {
        this.setModelProperty(model, annotation, modelProperty, modelProperty);
    }

    @Override
    public void setModelProperty(Object model, AnnotationMirror annotation, String modelProperty, String annotationAttribute) {
        if (!this.isDefaultValue(annotation, annotationAttribute)) {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(model, modelProperty);
            PropertyUtils.setPropertyValue(model, modelProperty, this.getAnnotationValue(annotation, annotationAttribute, propertyDescriptor.getPropertyType()));
        }
    }

    @Override
    public Object getConstant(TypeElement componentElement, String name) {
        List<VariableElement> fieldsIn = ElementFilter.fieldsIn(this.processingEnv.getElementUtils().getAllMembers(componentElement));
        Object value = null;
        for (VariableElement field : fieldsIn) {
            Set<Modifier> modifiers = field.getModifiers();
            if (!modifiers.contains((Object)Modifier.FINAL) || !modifiers.contains((Object)Modifier.STATIC) || !field.getSimpleName().toString().equals(name)) continue;
            value = field.getConstantValue();
        }
        return value;
    }

    @Override
    public void visitSupertypes(TypeElement type, SourceUtils.SuperTypeVisitor visitor) {
        this.visitSupertypes(type.asType(), visitor);
    }

    private void visitSupertypes(TypeMirror type, SourceUtils.SuperTypeVisitor visitor) {
        List<? extends TypeMirror> supertypes = this.processingEnv.getTypeUtils().directSupertypes(type);
        for (TypeMirror typeMirror : supertypes) {
            this.visitSupertypes(typeMirror, visitor);
        }
        visitor.visit(type);
    }

    private TypeElement asTypeElement(ClassName type) {
        return this.processingEnv.getElementUtils().getTypeElement(type.toString());
    }

    @Override
    public boolean isClassExists(ClassName type) {
        return null != this.asTypeElement(type);
    }

    @Override
    public TypeElement asTypeElement(TypeMirror mirror) {
        if (TypeKind.DECLARED.equals((Object)mirror.getKind())) {
            return (TypeElement)this.processingEnv.getTypeUtils().asElement(mirror);
        }
        return null;
    }

    protected final class AptBeanProperty
    implements SourceUtils.BeanProperty {
        private ExecutableElement getter;
        private ExecutableElement setter;
        private final String name;
        private ClassName type;

        public AptBeanProperty(String name) {
            this.name = name;
        }

        void setAccessMethod(ExecutableElement method, boolean setter) {
            if (setter) {
                this.setter = method;
            } else {
                this.getter = method;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDocComment() {
            String comment = this.getMethodComment(this.getter);
            if (null == comment) {
                comment = this.getMethodComment(this.setter);
            }
            return comment;
        }

        private String getMethodComment(ExecutableElement method) {
            if (null != method) {
                return AptSourceUtils.this.processingEnv.getElementUtils().getDocComment(method);
            }
            return null;
        }

        @Override
        public ClassName getType() {
            return this.type;
        }

        @Override
        public boolean isExists() {
            return !this.isAbstract(this.getter) && !this.isAbstract(this.setter);
        }

        private boolean isAbstract(ExecutableElement method) {
            return null != method && method.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        @Override
        public AnnotationMirror getAnnotationMirror(Class<? extends Annotation> annotationType) {
            if (this.isAnnotationPresent(this.getter, annotationType)) {
                return AptSourceUtils.this.getAnnotationMirror(this.getter, annotationType);
            }
            if (this.isAnnotationPresent(this.setter, annotationType)) {
                return AptSourceUtils.this.getAnnotationMirror(this.setter, annotationType);
            }
            return null;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.isAnnotationPresent(this.getter, annotationType) || this.isAnnotationPresent(this.setter, annotationType);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            if (this.isAnnotationPresent(this.getter, annotationType)) {
                return this.getter.getAnnotation(annotationType);
            }
            if (this.isAnnotationPresent(this.setter, annotationType)) {
                return this.setter.getAnnotation(annotationType);
            }
            return null;
        }

        private <T extends Annotation> boolean isAnnotationPresent(ExecutableElement method, Class<T> annotationType) {
            return null != method && null != method.getAnnotation(annotationType);
        }

        @Override
        public SourceUtils.ACCESS_TYPE getAccessType() {
            if (null != this.getter && null != this.setter) {
                return SourceUtils.ACCESS_TYPE.readWrite;
            }
            if (null == this.setter) {
                return SourceUtils.ACCESS_TYPE.readOnly;
            }
            return SourceUtils.ACCESS_TYPE.writeOnly;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AptBeanProperty other = (AptBeanProperty)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.name + "[" + this.getType() + "]";
        }
    }

    private static final class AnnotationAttributePredicate
    implements Predicate<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> {
        private final String propertyName;

        private AnnotationAttributePredicate(String propertyName) {
            this.propertyName = propertyName;
        }

        public boolean apply(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> input) {
            return this.propertyName.equals(input.getKey().getSimpleName().toString());
        }
    }
}

