/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.LibraryBuilder;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelBuilder;
import org.richfaces.cdk.ModelValidator;
import org.richfaces.cdk.apt.CdkProcessor;
import org.richfaces.cdk.apt.SourceUtilsProvider;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.model.ComponentLibrary;

public class CdkProcessorImpl
extends AbstractProcessor
implements CdkProcessor {
    private static final Set<String> PROCESSED_ANNOTATION = Collections.singleton("*");
    @Inject
    private Logger log;
    @Inject
    private Set<CdkAnnotationProcessor> processors;
    @Inject
    private ComponentLibrary library;
    @Inject
    private Set<ModelBuilder> builders;
    @Inject
    private SourceUtilsProvider sourceUtilsProducer;
    @Inject
    private ModelValidator validator;
    @Inject
    private LibraryBuilder builder;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.sourceUtilsProducer.setProcessingEnv(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (CdkAnnotationProcessor process : this.processors) {
                this.processAnnotation(process, roundEnv);
            }
        } else {
            this.processNonJavaSources();
            this.verify();
            if (0 == this.log.getErrorCount()) {
                this.generate();
            }
        }
        return false;
    }

    private void generate() {
        this.log.debug((CharSequence)"Generate output files");
        this.builder.generate(this.library);
    }

    private void verify() {
        try {
            this.log.debug((CharSequence)"Validate model");
            this.validator.verify(this.library);
        }
        catch (CdkException e) {
            this.sendError(e);
        }
    }

    @Override
    public void processNonJavaSources() {
        for (ModelBuilder builder : this.builders) {
            this.log.debug((CharSequence)("Run builder " + builder.getClass().getName()));
            try {
                builder.build();
            }
            catch (CdkException e) {
                this.sendError(e);
            }
        }
    }

    protected void processAnnotation(CdkAnnotationProcessor processor, RoundEnvironment environment) {
        Class<? extends Annotation> processedAnnotation = processor.getProcessedAnnotation();
        this.log.debug((CharSequence)("Process all elements annotated with " + processedAnnotation.getName()));
        Target target = processedAnnotation.getAnnotation(Target.class);
        Set<? extends Element> rootElements = environment.getRootElements();
        for (Element element : rootElements) {
            if (this.isAppropriateTarget(element, target)) {
                this.processElement(processor, processedAnnotation, element);
                continue;
            }
            for (Element element2 : element.getEnclosedElements()) {
                if (!this.isAppropriateTarget(element2, target)) continue;
                this.processElement(processor, processedAnnotation, element2);
            }
        }
    }

    private void processElement(CdkAnnotationProcessor processor, Class<? extends Annotation> processedAnnotation, Element element) {
        if (null != element.getAnnotation(processedAnnotation)) {
            try {
                this.log.debug((CharSequence)("Process " + element.getSimpleName() + " annotated with " + processedAnnotation.getName()));
                processor.process(element, this.library);
            }
            catch (CdkProcessingException e) {
                this.sendError(element, e);
            }
        }
    }

    private boolean isAppropriateTarget(Element element, Target target) {
        boolean match = false;
        ElementKind kind = element.getKind();
        if (null != target) {
            block6: for (ElementType targetType : target.value()) {
                switch (targetType) {
                    case TYPE: {
                        match |= ElementKind.CLASS.equals((Object)kind) || ElementKind.INTERFACE.equals((Object)kind) || ElementKind.ENUM.equals((Object)kind);
                        continue block6;
                    }
                    case PACKAGE: {
                        match |= ElementKind.PACKAGE.equals((Object)kind);
                        continue block6;
                    }
                    case METHOD: {
                        match |= ElementKind.METHOD.equals((Object)kind);
                        continue block6;
                    }
                    case FIELD: {
                        match |= ElementKind.FIELD.equals((Object)kind);
                        continue block6;
                    }
                }
            }
        } else {
            match = ElementKind.CLASS.equals((Object)kind) || ElementKind.INTERFACE.equals((Object)kind) || ElementKind.ENUM.equals((Object)kind) || ElementKind.PACKAGE.equals((Object)kind) || ElementKind.METHOD.equals((Object)kind) || ElementKind.FIELD.equals((Object)kind);
        }
        return match;
    }

    protected void sendError(Element componentElement, Exception e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), componentElement);
    }

    protected void sendError(CdkException e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return PROCESSED_ANNOTATION;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }
}

