/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.richfaces.cdk.CdkClassLoader;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.Output;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.Source;
import org.richfaces.cdk.Sources;
import org.richfaces.cdk.apt.AptException;
import org.richfaces.cdk.apt.CdkProcessor;
import org.richfaces.cdk.apt.CompilationTaskFactory;
import org.richfaces.cdk.apt.DiagnosticListenerImplementation;

public class TaskFactoryImpl
implements CompilationTaskFactory {
    private static List<String> compilerOptions = new ArrayList<String>(Arrays.asList("-proc:only", "-implicit:class"));
    @Inject
    Logger log;
    @Inject
    Locale locale;
    @Inject
    private Charset charset;
    @Inject
    private CdkClassLoader classPathLoader;
    @Inject
    @Output(value=Outputs.JAVA_CLASSES)
    private FileManager outputFolder;
    @Inject
    @Source(value=Sources.JAVA_SOURCES)
    private FileManager sourceFolders;
    @Inject
    private CdkProcessor cdkProcessor;
    private JavaCompiler javaCompiler;
    private StandardJavaFileManager fileManager;

    @Override
    public JavaCompiler.CompilationTask get() throws AptException {
        if (this.sourceFolders.getFiles().iterator().hasNext()) {
            Iterable<? extends JavaFileObject> sourceObjects = this.getFileManager().getJavaFileObjectsFromFiles(this.sourceFolders.getFiles());
            if (this.log.isDebugEnabled()) {
                compilerOptions.add("-verbose");
            }
            JavaCompiler.CompilationTask task = this.getJavaCompiler().getTask(null, this.getFileManager(), new DiagnosticListenerImplementation(this.log, this.locale), compilerOptions, null, sourceObjects);
            task.setLocale(this.locale);
            task.setProcessors(Collections.singleton(this.cdkProcessor));
            return task;
        }
        return new JavaCompiler.CompilationTask(){

            @Override
            public void setProcessors(Iterable<? extends Processor> processors) {
            }

            @Override
            public void setLocale(Locale locale) {
            }

            @Override
            public Boolean call() {
                TaskFactoryImpl.this.cdkProcessor.processNonJavaSources();
                return 0 == TaskFactoryImpl.this.log.getErrorCount();
            }
        };
    }

    private StandardJavaFileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = this.getJavaCompiler().getStandardFileManager(new DiagnosticListenerImplementation(this.log, this.locale), this.locale, this.charset);
            try {
                Iterable existedFolders;
                this.fileManager.setLocation(StandardLocation.CLASS_PATH, this.classPathLoader.getFiles());
                Iterable<File> outputFolders = this.outputFolder.getFolders();
                if (null != outputFolders && (existedFolders = Iterables.filter(outputFolders, (Predicate)new Predicate<File>(){

                    public boolean apply(File input) {
                        return input.exists();
                    }
                })).iterator().hasNext()) {
                    this.fileManager.setLocation(StandardLocation.SOURCE_OUTPUT, outputFolders);
                }
                this.fileManager.setLocation(StandardLocation.SOURCE_PATH, this.sourceFolders.getFolders());
            }
            catch (IOException e) {
                throw new CdkException("Cannot configure JavaFileManager for compilator", e);
            }
        }
        return this.fileManager;
    }

    private JavaCompiler getJavaCompiler() {
        if (this.javaCompiler == null) {
            this.javaCompiler = ToolProvider.getSystemJavaCompiler();
        }
        return this.javaCompiler;
    }
}

