/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.Signature;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.AttributesProcessor;
import org.richfaces.cdk.apt.processors.DescriptionProcessor;
import org.richfaces.cdk.model.BeanModelBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.EventName;
import org.richfaces.cdk.model.MethodSignature;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.util.JavaUtils;
import org.richfaces.cdk.xmlconfig.FragmentParser;

public class AttributesProcessorImpl
implements AttributesProcessor {
    private static final ClassName SIGNATURE_NONE_CLASS_NAME = ClassName.get(Signature.NONE.class);
    private static final ClassName STRING_TYPE = ClassName.get(String.class);
    @Inject
    private Logger log;
    private final DescriptionProcessor descriptionProcessor;
    private final Provider<SourceUtils> utilsProvider;
    private final FragmentParser parser;

    @Inject
    public AttributesProcessorImpl(DescriptionProcessor descriptionProcessor, Provider<SourceUtils> utilsProvider, FragmentParser parser) {
        this.descriptionProcessor = descriptionProcessor;
        this.utilsProvider = utilsProvider;
        this.parser = parser;
    }

    protected void processAttribute(SourceUtils.BeanProperty beanProperty, PropertyBase attribute) {
        attribute.setType(beanProperty.getType());
        AnnotationMirror attributeAnnotarion = beanProperty.getAnnotationMirror(Attribute.class);
        if (attributeAnnotarion == null) {
            String value;
            attribute.setGenerate(!beanProperty.isExists());
            attribute.setDescription(beanProperty.getDocComment());
            attribute.setHidden(true);
            if (attribute.getType().isPrimitive() && (value = this.getPimitiveDefaultValue(attribute.getType().getName())) != null) {
                attribute.setDefaultValue(value);
            }
        } else {
            SourceUtils utils = (SourceUtils)this.utilsProvider.get();
            utils.setModelProperty(attribute, attributeAnnotarion, "hidden");
            utils.setModelProperty(attribute, attributeAnnotarion, "literal");
            utils.setModelProperty(attribute, attributeAnnotarion, "passThrough");
            utils.setModelProperty(attribute, attributeAnnotarion, "required");
            utils.setModelProperty(attribute, attributeAnnotarion, "readOnly");
            if (!utils.isDefaultValue(attributeAnnotarion, "generate")) {
                attribute.setGenerate(utils.getAnnotationValue(attributeAnnotarion, "generate", Boolean.TYPE));
            } else {
                attribute.setGenerate(!beanProperty.isExists());
            }
            this.descriptionProcessor.processDescription(attribute, utils.getAnnotationValue(attributeAnnotarion, "description", AnnotationMirror.class), beanProperty.getDocComment());
            this.setDefaultValue(attribute, attributeAnnotarion);
            utils.setModelProperty(attribute, attributeAnnotarion, "suggestedValue");
            attribute.setSignature(this.getSignature(attributeAnnotarion));
            for (AnnotationMirror event : utils.getAnnotationValues(attributeAnnotarion, "events", AnnotationMirror.class)) {
                this.setBehaviorEvent(attribute, event);
            }
        }
    }

    private void setDefaultValue(PropertyBase attribute, AnnotationMirror attributeAnnotarion) {
        SourceUtils utils = (SourceUtils)this.utilsProvider.get();
        if (utils.isDefaultValue(attributeAnnotarion, "defaultValue")) {
            if (attribute.getType().isPrimitive()) {
                String pimitiveDefaultValue = this.getPimitiveDefaultValue(attribute.getType().getName());
                attribute.setDefaultValue(pimitiveDefaultValue);
            }
        } else {
            String defaultValue = utils.getAnnotationValue(attributeAnnotarion, "defaultValue", String.class);
            if (STRING_TYPE.equals(attribute.getType())) {
                defaultValue = JavaUtils.getEscapedString(defaultValue);
            }
            attribute.setDefaultValue(defaultValue);
        }
    }

    private String getPimitiveDefaultValue(String typeName) {
        if (this.isInstace(Boolean.TYPE, typeName)) {
            return "false";
        }
        if (this.isInstace(Integer.TYPE, typeName)) {
            return "Integer.MIN_VALUE";
        }
        if (this.isInstace(Long.TYPE, typeName)) {
            return "Long.MIN_VALUE";
        }
        if (this.isInstace(Byte.TYPE, typeName)) {
            return "Byte.MIN_VALUE";
        }
        if (this.isInstace(Short.TYPE, typeName)) {
            return "Short.MIN_VALUE";
        }
        if (this.isInstace(Float.TYPE, typeName)) {
            return "Float.MIN_VALUE";
        }
        if (this.isInstace(Double.TYPE, typeName)) {
            return "Double.MIN_VALUE";
        }
        if (this.isInstace(Character.TYPE, typeName)) {
            return "Character.MIN_VALUE";
        }
        return null;
    }

    private boolean isInstace(Class<?> byteClass, String typeName) {
        return byteClass.getSimpleName().equals(typeName);
    }

    private MethodSignature getSignature(AnnotationMirror attributeAnnotarion) {
        AnnotationMirror signatureAnnotation;
        ClassName returnType;
        SourceUtils utils = (SourceUtils)this.utilsProvider.get();
        if (!utils.isDefaultValue(attributeAnnotarion, "signature") && !SIGNATURE_NONE_CLASS_NAME.equals(returnType = utils.getAnnotationValue(signatureAnnotation = utils.getAnnotationValue(attributeAnnotarion, "signature", AnnotationMirror.class), "returnType", ClassName.class))) {
            MethodSignature methodSignature = new MethodSignature();
            methodSignature.setParameters(Lists.newArrayList(utils.getAnnotationValues(signatureAnnotation, "parameters", ClassName.class)));
            methodSignature.setReturnType(returnType);
            return methodSignature;
        }
        return null;
    }

    private void setBehaviorEvent(PropertyBase attribute, AnnotationMirror eventMirror) {
        if (null != eventMirror) {
            SourceUtils utils = (SourceUtils)this.utilsProvider.get();
            EventName event = new EventName();
            utils.setModelProperty(event, eventMirror, "name", "value");
            utils.setModelProperty(event, eventMirror, "defaultEvent");
            attribute.getEventNames().add(event);
        }
    }

    @Override
    public void processType(final BeanModelBase component, TypeElement element) throws CdkException {
        this.log.debug((CharSequence)"AttributesProcessorImpl.processType");
        this.log.debug((CharSequence)("  -> component = " + component));
        this.log.debug((CharSequence)("  -> typeElement = " + element));
        this.log.debug((CharSequence)"  -- Process XML files with standard attributes definitions.");
        this.log.debug((CharSequence)"     -> sourceUtils.visitSupertypes...");
        SourceUtils sourceUtils = this.getSourceUtils();
        sourceUtils.visitSupertypes(element, new SourceUtils.SuperTypeVisitor(){

            @Override
            public void visit(TypeMirror type) {
                String uri = ((Object)type).toString() + ".xml";
                try {
                    AttributesProcessorImpl.this.log.debug((CharSequence)("        -> visit - " + ((Object)type).toString()));
                    component.getAttributes().addAll(AttributesProcessorImpl.this.parseProperties(uri));
                }
                catch (CdkException e) {
                    AttributesProcessorImpl.this.log.error((Throwable)e);
                }
                catch (FileNotFoundException e) {
                    AttributesProcessorImpl.this.log.debug((CharSequence)("No properties description found at " + uri));
                }
            }
        });
        this.log.debug((CharSequence)"  -- Process Java files.");
        HashSet properties = Sets.newHashSet();
        properties.addAll(sourceUtils.getBeanPropertiesAnnotatedWith(Attribute.class, element));
        for (SourceUtils.BeanProperty beanProperty : properties) {
            this.processAttribute(beanProperty, component.getOrCreateAttribute(beanProperty.getName()));
        }
    }

    private Collection<? extends PropertyBase> parseProperties(String uri) throws FileNotFoundException {
        return this.parser.parseProperties("urn:attributes:" + uri);
    }

    private SourceUtils getSourceUtils() {
        return (SourceUtils)this.utilsProvider.get();
    }

    @Override
    public void processXmlFragment(BeanModelBase component, String ... attributesConfig) {
        for (String attributes : attributesConfig) {
            try {
                component.getAttributes().addAll(this.parseProperties(attributes));
            }
            catch (CdkException e) {
                this.log.error((Throwable)e);
            }
            catch (FileNotFoundException e) {
                this.log.error((CharSequence)("No properties description found at " + attributes));
            }
        }
    }
}

