/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.annotations.JsfBehavior;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.BehaviorModel;
import org.richfaces.cdk.model.ComponentLibrary;

@SupportedAnnotationTypes(value={"javax.faces.component.FacesComponent", "org.richfaces.cdk.annotations.JsfBehavior"})
public class BehaviorProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    @Override
    public void process(Element element, ComponentLibrary library) throws CdkProcessingException {
        SourceUtils sourceUtils = this.getSourceUtils();
        AnnotationMirror behavior = sourceUtils.getAnnotationMirror(element, JsfBehavior.class);
        BehaviorModel behaviorModel = new BehaviorModel();
        sourceUtils.setModelProperty(behaviorModel, behavior, "id");
        this.setClassNames((TypeElement)element, behaviorModel, behavior);
        this.setTagInfo(behavior, behaviorModel);
        this.processAttributes((TypeElement)element, behaviorModel, behavior);
        this.setDescription(behaviorModel, behavior, this.getDocComment(element));
        if (!sourceUtils.isDefaultValue(behavior, "renderer")) {
            AnnotationMirror renderer = sourceUtils.getAnnotationValue(behavior, "renderer", AnnotationMirror.class);
            sourceUtils.setModelProperty(behaviorModel, renderer, "rendererType", "type");
        }
        library.getBehaviors().add(behaviorModel);
    }

    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return JsfBehavior.class;
    }
}

